/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;

public final class Utils {
    static final ServletInputStream NULL_SERVLET_INPUT_STREAM = new ServletInputStream(){

        public int read() throws IOException {
            return -1;
        }

        public boolean isFinished() {
            return true;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            try {
                readListener.onAllDataRead();
            }
            catch (IOException e) {
                readListener.onError((Throwable)e);
            }
        }
    };
    static final Reader NULL_READER = new Reader(){

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            return -1;
        }

        @Override
        public void close() throws IOException {
        }
    };
    static final ServletOutputStream NULL_SERVLET_OUTPUT_STREAM = new ServletOutputStream(){
        private IOException ioe1;
        private IOException ioe2;

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
            if (this.ioe1 == null) {
                this.ioe1 = new IOException("Can't write to a websocket using ServletOutputStream");
            }
            writeListener.onError((Throwable)this.ioe1);
        }

        public void write(int b) throws IOException {
            if (this.ioe2 == null) {
                this.ioe2 = new IOException("Can't write to a websocket using ServletOutputStream");
            }
            throw this.ioe2;
        }
    };
    static final Writer NULL_WRITER = new Writer(){
        private IOException ioe;

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            if (this.ioe == null) {
                this.ioe = new IOException("Can't write to a websocket using ServletWriter");
            }
            throw this.ioe;
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    };

    public static byte[] toArray(long length) {
        long value = length;
        byte[] b = new byte[8];
        for (int i = 7; i >= 0 && value > 0L; value >>= 8, --i) {
            b[i] = (byte)(value & 0xFFL);
        }
        return b;
    }

    public static long toLong(byte[] bytes, int start, int end) {
        long value = 0L;
        for (int i = start; i < end; ++i) {
            value <<= 8;
            value ^= (long)bytes[i] & 0xFFL;
        }
        return value;
    }

    public static List<String> toString(byte[] bytes) {
        return Utils.toString(bytes, 0, bytes.length);
    }

    public static List<String> toString(byte[] bytes, int start, int end) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = start; i < end; ++i) {
            list.add(Integer.toHexString(bytes[i] & 0xFF).toUpperCase(Locale.US));
        }
        return list;
    }
}

