/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.node.SaxParserHandler;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Service
public class SaxParserHandlerBundled
extends SaxParserHandler {
    private static final String BUNDLED_SCHEMA_ROOT = "/schemas";
    private static final String BUNDLED_DTD_ROOT = "/dtds";

    @Override
    public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
        InputSource result = null;
        try {
            if (DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) {
                DOLUtils.getDefaultLogger().fine("Asked to resolve  " + publicID + " system id = " + systemID);
            }
            if (publicID == null) {
                if (systemID == null || systemID.lastIndexOf(47) == systemID.length()) {
                    return null;
                }
                result = this.openSchemaSource(systemID);
                if (result == null) {
                    result = new InputSource(systemID);
                }
            } else if (SaxParserHandlerBundled.getMapping().containsKey(publicID)) {
                this.publicID = publicID;
                result = this.openDTDSource(publicID);
            } else if (systemID != null && (result = this.openSchemaSource(systemID)) == null) {
                result = this.openInputSource(BUNDLED_DTD_ROOT, systemID);
            }
        }
        catch (Exception exc) {
            DOLUtils.getDefaultLogger().log(Level.SEVERE, "Error occurred", exc);
            throw new SAXException(exc);
        }
        return result;
    }

    private InputSource openSchemaSource(String systemID) {
        return this.openInputSource(BUNDLED_SCHEMA_ROOT, systemID);
    }

    private InputSource openDTDSource(String publicID) {
        return this.openInputSource(BUNDLED_DTD_ROOT, SaxParserHandlerBundled.getMapping().get(publicID));
    }

    private InputSource openInputSource(String localRoot, String systemID) {
        InputStream stream;
        String targetID = localRoot + "/" + systemID.substring(systemID.lastIndexOf("/") + 1);
        URL url = this.getClass().getResource(targetID);
        try {
            stream = url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            stream = null;
        }
        InputSource source = null;
        if (stream != null) {
            source = new InputSource(stream);
            source.setSystemId(url.toString());
        }
        return source;
    }
}

