/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.full.deployment;

import com.sun.enterprise.loader.ASURLClassLoader;
import java.util.LinkedList;
import java.util.List;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.glassfish.javaee.full.deployment.EarLibClassLoader;

public class EarClassLoader
extends ASURLClassLoader {
    private List<ClassLoaderHolder> moduleClassLoaders = new LinkedList<ClassLoaderHolder>();
    boolean isPreDestroyCalled = false;

    public EarClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public void addModuleClassLoader(String moduleName, ClassLoader cl) {
        this.moduleClassLoaders.add(new ClassLoaderHolder(moduleName, cl));
    }

    public ClassLoader getModuleClassLoader(String moduleName) {
        for (ClassLoaderHolder clh : this.moduleClassLoaders) {
            if (!moduleName.equals(clh.moduleName)) continue;
            return clh.loader;
        }
        return null;
    }

    public void preDestroy() {
        if (this.isPreDestroyCalled) {
            return;
        }
        try {
            for (ClassLoaderHolder clh : this.moduleClassLoaders) {
                if (clh.loader instanceof EarLibClassLoader || clh.loader instanceof EarClassLoader || this.isRARCL(clh.loader)) continue;
                try {
                    ((PreDestroy)PreDestroy.class.cast(clh.loader)).preDestroy();
                }
                catch (Exception exception) {}
            }
            super.preDestroy();
            DelegatingClassLoader dcl = (DelegatingClassLoader)this.getParent();
            for (DelegatingClassLoader.ClassFinder cf : dcl.getDelegates()) {
                try {
                    ((PreDestroy)PreDestroy.class.cast(cf)).preDestroy();
                }
                catch (Exception exception) {}
            }
            ((PreDestroy)PreDestroy.class.cast(this.getParent().getParent())).preDestroy();
            this.moduleClassLoaders = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isPreDestroyCalled = true;
    }

    private boolean isRARCL(ClassLoader loader) {
        DelegatingClassLoader connectorCL = (DelegatingClassLoader)this.getParent();
        if (!(loader instanceof DelegatingClassLoader.ClassFinder)) {
            return false;
        }
        return connectorCL.getDelegates().contains((DelegatingClassLoader.ClassFinder)loader);
    }

    protected String getClassLoaderName() {
        return "EarClassLoader";
    }

    private static class ClassLoaderHolder {
        final ClassLoader loader;
        final String moduleName;

        private ClassLoaderHolder(String moduleName, ClassLoader loader) {
            this.loader = loader;
            this.moduleName = moduleName;
        }
    }
}

