/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node;

import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbCMPEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.FieldDescriptor;
import org.glassfish.ejb.deployment.descriptor.IASEjbCMPEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.QueryDescriptor;
import org.glassfish.ejb.deployment.node.CmpFieldNode;
import org.glassfish.ejb.deployment.node.InterfaceBasedEjbNode;
import org.glassfish.ejb.deployment.node.QueryNode;
import org.w3c.dom.Node;

public class EjbEntityNode
extends InterfaceBasedEjbNode<EjbEntityDescriptor> {
    private EjbEntityDescriptor descriptor;

    public EjbEntityNode() {
        this.registerElementHandler(new XMLElement("cmp-field"), CmpFieldNode.class);
        this.registerElementHandler(new XMLElement("query"), QueryNode.class);
    }

    @Override
    public EjbEntityDescriptor getEjbDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new EjbEntityDescriptor();
            this.descriptor.setEjbBundleDescriptor((EjbBundleDescriptorImpl)((Object)this.getParentNode().getDescriptor()));
        }
        return this.descriptor;
    }

    private EjbCMPEntityDescriptor getCMPEntityDescriptor() {
        EjbEntityDescriptor current = this.getEjbDescriptor();
        if (!(current instanceof EjbCMPEntityDescriptor)) {
            this.descriptor = new IASEjbCMPEntityDescriptor(current);
        }
        return (EjbCMPEntityDescriptor)this.descriptor;
    }

    @Override
    public void addDescriptor(Object newDescriptor) {
        if (newDescriptor instanceof FieldDescriptor) {
            this.getCMPEntityDescriptor().getPersistenceDescriptor().addCMPField((FieldDescriptor)((Object)newDescriptor));
        } else if (newDescriptor instanceof QueryDescriptor) {
            QueryDescriptor newQuery = (QueryDescriptor)((Object)newDescriptor);
            this.getCMPEntityDescriptor().getPersistenceDescriptor().setQueryFor(newQuery.getQueryMethodDescriptor(), newQuery);
        } else {
            super.addDescriptor(newDescriptor);
        }
    }

    @Override
    protected Map getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("persistence-type", "setPersistenceType");
        table.put("prim-key-class", "setPrimaryKeyClassName");
        table.put("reentrant", "setReentrant");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("cmp-version".equals(element.getQName())) {
            if ("1.x".equals(value)) {
                this.getCMPEntityDescriptor().setCMPVersion(1);
            } else if ("2.x".equals(value)) {
                this.getCMPEntityDescriptor().setCMPVersion(2);
            }
        } else if ("abstract-schema-name".equals(element.getQName())) {
            this.getCMPEntityDescriptor().setAbstractSchemaName(value);
        } else if ("primkey-field".equals(element.getQName())) {
            this.getCMPEntityDescriptor().setPrimaryKeyFieldDesc(new FieldDescriptor(value));
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, EjbEntityDescriptor ejbDesc) {
        Set queriedMethods;
        EjbCMPEntityDescriptor cmpDesc;
        Node ejbNode = super.writeDescriptor(parent, nodeName, (Object)ejbDesc);
        this.writeDisplayableComponentInfo(ejbNode, (Descriptor)ejbDesc);
        this.writeCommonHeaderEjbDescriptor(ejbNode, ejbDesc);
        EjbEntityNode.appendTextChild((Node)ejbNode, (String)"persistence-type", (String)ejbDesc.getPersistenceType());
        EjbEntityNode.appendTextChild((Node)ejbNode, (String)"prim-key-class", (String)ejbDesc.getPrimaryKeyClassName());
        EjbEntityNode.appendTextChild((Node)ejbNode, (String)"reentrant", (String)ejbDesc.getReentrant());
        if (ejbDesc instanceof EjbCMPEntityDescriptor) {
            cmpDesc = (EjbCMPEntityDescriptor)ejbDesc;
            if (cmpDesc.getCMPVersion() == 1) {
                EjbEntityNode.appendTextChild((Node)ejbNode, (String)"cmp-version", (String)"1.x");
            } else {
                EjbEntityNode.appendTextChild((Node)ejbNode, (String)"cmp-version", (String)"2.x");
            }
            EjbEntityNode.appendTextChild((Node)ejbNode, (String)"abstract-schema-name", (String)cmpDesc.getAbstractSchemaName());
            CmpFieldNode cmpNode = new CmpFieldNode();
            for (FieldDescriptor aField : cmpDesc.getPersistenceDescriptor().getCMPFields()) {
                cmpNode.writeDescriptor(ejbNode, "cmp-field", aField);
            }
            if (cmpDesc.getPrimaryKeyFieldDesc() != null) {
                EjbEntityNode.appendTextChild((Node)ejbNode, (String)"primkey-field", (String)cmpDesc.getPrimaryKeyFieldDesc().getName());
            }
        }
        this.writeEnvEntryDescriptors(ejbNode, ejbDesc.getEnvironmentProperties().iterator());
        this.writeEjbReferenceDescriptors(ejbNode, ejbDesc.getEjbReferenceDescriptors().iterator());
        this.writeServiceReferenceDescriptors(ejbNode, ejbDesc.getServiceReferenceDescriptors().iterator());
        this.writeResourceRefDescriptors(ejbNode, ejbDesc.getResourceReferenceDescriptors().iterator());
        this.writeResourceEnvRefDescriptors(ejbNode, ejbDesc.getResourceEnvReferenceDescriptors().iterator());
        this.writeMessageDestinationRefDescriptors(ejbNode, ejbDesc.getMessageDestinationReferenceDescriptors().iterator());
        this.writeEntityManagerReferenceDescriptors(ejbNode, ejbDesc.getEntityManagerReferenceDescriptors().iterator());
        this.writeEntityManagerFactoryReferenceDescriptors(ejbNode, ejbDesc.getEntityManagerFactoryReferenceDescriptors().iterator());
        this.writeLifeCycleCallbackDescriptors(ejbNode, "post-construct", ejbDesc.getPostConstructDescriptors());
        this.writeLifeCycleCallbackDescriptors(ejbNode, "pre-destroy", ejbDesc.getPreDestroyDescriptors());
        this.writeResourceDescriptors(ejbNode, ejbDesc.getAllResourcesDescriptors().iterator());
        this.writeRoleReferenceDescriptors(ejbNode, ejbDesc.getRoleReferences().iterator());
        this.writeSecurityIdentityDescriptor(ejbNode, ejbDesc);
        if (ejbDesc instanceof EjbCMPEntityDescriptor && (queriedMethods = (cmpDesc = (EjbCMPEntityDescriptor)ejbDesc).getPersistenceDescriptor().getQueriedMethods()).size() > 0) {
            QueryNode queryNode = new QueryNode();
            Iterator e = queriedMethods.iterator();
            while (e.hasNext()) {
                queryNode.writeDescriptor(ejbNode, "query", cmpDesc.getPersistenceDescriptor().getQueryFor((MethodDescriptor)e.next()));
            }
        }
        return ejbNode;
    }
}

