/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.mc.api;

import javax.xml.namespace.QName;

public enum McProtocolVersion {
    WSMC200702("http://docs.oasis-open.org/ws-rx/wsmc/200702", "http://docs.oasis-open.org/ws-rx/wsmc/200702");

    public final String protocolNamespaceUri;
    public final String policyNamespaceUri;
    public final String wsmcAction;
    public final String wsmcFaultAction;
    public final QName messagePendingHeaderName;
    public final QName unsupportedSelectionFaultCode;
    public final QName missingSelectionFaultCode;

    private McProtocolVersion(String protocolNamespaceUri, String policyNamespaceUri) {
        this.protocolNamespaceUri = protocolNamespaceUri;
        this.policyNamespaceUri = policyNamespaceUri;
        this.wsmcAction = protocolNamespaceUri + "/MakeConnection";
        this.wsmcFaultAction = protocolNamespaceUri + "/fault";
        this.messagePendingHeaderName = new QName(protocolNamespaceUri, "MessagePending");
        this.unsupportedSelectionFaultCode = new QName(protocolNamespaceUri, "UnsupportedSelection");
        this.missingSelectionFaultCode = new QName(protocolNamespaceUri, "MissingSelection");
    }

    public static McProtocolVersion getDefault() {
        return WSMC200702;
    }

    public boolean isProtocolAction(String wsaAction) {
        return wsaAction != null && (this.wsmcAction.equals(wsaAction) || this.isFault(wsaAction));
    }

    public boolean isFault(String wsaAction) {
        return this.wsmcFaultAction.equals(wsaAction);
    }
}

