/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.shell;

import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.options.Option;
import org.apache.felix.gogo.options.Options;
import org.apache.felix.gogo.shell.Console;
import org.apache.felix.gogo.shell.History;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class Shell {
    static final String[] functions = new String[]{"gosh", "sh", "source", "history"};
    private static final URI CWD = new File(".").toURI();
    private final URI baseURI;
    private final BundleContext context;
    private final CommandProcessor processor;
    private final History history;
    private volatile Bundle systemBundle;

    public Shell(BundleContext context, CommandProcessor processor) {
        this.context = context;
        this.processor = processor;
        String baseDir = context.getProperty("gosh.home");
        baseDir = baseDir == null ? context.getProperty("user.dir") : baseDir;
        this.baseURI = new File(baseDir).toURI();
        this.history = new History();
    }

    public Object gosh(CommandSession session, String[] argv) throws Exception {
        String[] usage = new String[]{"gosh - execute script with arguments in a new session", "  args are available as session variables $1..$9 and $args.", "Usage: gosh [OPTIONS] [script-file [args..]]", "  -c --command             pass all remaining args to sub-shell", "     --nointeractive       don't start interactive session", "     --login               login shell (same session, reads etc/gosh_profile)", "  -s --noshutdown          don't shutdown framework when script completes", "  -q --quiet               don't display message-of-the-day", "  -x --xtrace              echo commands before execution", "  -? --help                show help", "If no script-file, an interactive shell is started, type $D to exit."};
        Option opt = Options.compile(usage).setOptionsFirst(true).parse(argv);
        List<String> args = opt.args();
        boolean login = opt.isSet("login");
        boolean interactive = !opt.isSet("nointeractive");
        this.systemBundle = this.context.getBundle(0L);
        if (opt.isSet("help")) {
            opt.usage();
            if (login && !opt.isSet("noshutdown")) {
                this.shutdown();
            }
            return null;
        }
        if (opt.isSet("command") && args.isEmpty()) {
            throw opt.usageError("option --command requires argument(s)");
        }
        CommandSession newSession = login ? session : this.processor.createSession(session.getKeyboard(), (OutputStream)session.getConsole(), (OutputStream)System.err);
        newSession.put(".gosh_login", (Object)login);
        newSession.put(".gosh_interactive", (Object)interactive);
        newSession.put(".gosh_quiet", (Object)opt.isSet("quiet"));
        if (opt.isSet("xtrace")) {
            newSession.put("echo", (Object)true);
        }
        if (login && interactive) {
            Object uri = this.baseURI.resolve("etc/gosh_profile");
            if (!new File((URI)uri).exists()) {
                URL url = this.getClass().getResource("/ext/gosh_profile");
                if (url == null) {
                    url = this.getClass().getResource("/gosh_profile");
                }
                Object object = uri = url == null ? null : url.toURI();
            }
            if (uri != null) {
                this.source(session, ((URI)uri).toString());
            }
        }
        for (String key : Shell.getVariables(session)) {
            if (!key.matches("[.]?[A-Z].*")) continue;
            newSession.put(key, session.get(key));
        }
        Object result = null;
        if (args.isEmpty()) {
            if (interactive) {
                result = this.console(newSession);
            }
        } else {
            CharSequence program;
            if (opt.isSet("command")) {
                StringBuilder buf = new StringBuilder();
                for (String arg : args) {
                    if (buf.length() > 0) {
                        buf.append(' ');
                    }
                    buf.append(arg);
                }
                program = buf;
            } else {
                URI script = Shell.cwd(session).resolve(args.remove(0));
                newSession.put("0", (Object)script);
                newSession.put("args", args);
                for (int i = 0; i < args.size(); ++i) {
                    newSession.put(String.valueOf(i + 1), (Object)args.get(i));
                }
                program = this.readScript(script);
            }
            result = newSession.execute(program);
        }
        if (login && interactive) {
            if (opt.isSet("noshutdown")) {
                System.out.println("gosh: stopping shell");
            } else {
                System.out.println("gosh: stopping shell and framework");
                this.shutdown();
            }
        }
        return result;
    }

    public Object sh(CommandSession session, String[] argv) throws Exception {
        return this.gosh(session, argv);
    }

    private void shutdown() throws BundleException {
        if (this.systemBundle != null) {
            this.systemBundle.stop();
            this.systemBundle = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object source(CommandSession session, String script) throws Exception {
        URI uri = Shell.cwd(session).resolve(script);
        session.put("0", (Object)uri);
        try {
            Object object = session.execute(this.readScript(uri));
            return object;
        }
        finally {
            session.put("0", null);
        }
    }

    private Object console(CommandSession session) {
        Console console = new Console(session, this.history);
        console.run();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharSequence readScript(URI script) throws Exception {
        CharBuffer buf = CharBuffer.allocate(4096);
        StringBuilder sb = new StringBuilder();
        URLConnection conn = script.toURL().openConnection();
        InputStreamReader in = null;
        try {
            in = new InputStreamReader(conn.getInputStream());
            while (in.read(buf) > 0) {
                buf.flip();
                sb.append(buf);
                buf.clear();
            }
        }
        finally {
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).disconnect();
            }
            if (in != null) {
                in.close();
            }
        }
        return sb;
    }

    static Set<String> getVariables(CommandSession session) {
        return (Set)session.get(".variables");
    }

    static URI cwd(CommandSession session) {
        Object cwd = session.get("_cwd");
        if (cwd instanceof URI) {
            return (URI)cwd;
        }
        if (cwd instanceof File) {
            return ((File)cwd).toURI();
        }
        return CWD;
    }

    public String[] history() {
        Iterator<String> history = this.history.getHistory();
        ArrayList<String> lines = new ArrayList<String>();
        int i = 1;
        while (history.hasNext()) {
            lines.add(String.format("%5d  %s", i, history.next()));
            ++i;
        }
        return lines.toArray(new String[lines.size()]);
    }
}

