/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.glassfish.grizzly.config.ssl.DefaultServerSocketFactory;

public abstract class ServerSocketFactory
implements Cloneable {
    private static ServerSocketFactory theFactory;
    protected SSLContext context;
    protected final Map<String, Object> attributes = new HashMap<String, Object>();

    protected ServerSocketFactory() {
    }

    public abstract ServerSocket createSocket(int var1) throws IOException, InstantiationException;

    public abstract ServerSocket createSocket(int var1, int var2) throws IOException, InstantiationException;

    public abstract ServerSocket createSocket(int var1, int var2, InetAddress var3) throws IOException, InstantiationException;

    public abstract Socket acceptSocket(ServerSocket var1) throws IOException;

    public abstract void handshake(Socket var1) throws IOException;

    public abstract void init() throws IOException;

    public void initSocket(Socket s) {
    }

    public SSLContext getSSLContext() {
        return this.context;
    }

    public void setAttribute(String name, Object value) {
        if (name != null && value != null) {
            this.attributes.put(name, value);
        }
    }

    public static synchronized ServerSocketFactory getDefault() {
        if (theFactory == null) {
            theFactory = new DefaultServerSocketFactory();
        }
        try {
            return (ServerSocketFactory)theFactory.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

