/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query;

import com.sun.jdo.api.persistence.support.JDOQueryException;
import com.sun.jdo.api.persistence.support.Query;
import com.sun.jdo.api.persistence.support.Transaction;
import com.sun.jdo.spi.persistence.support.sqlstore.PersistenceManager;
import com.sun.jdo.spi.persistence.support.sqlstore.RetrieveDesc;
import com.sun.jdo.spi.persistence.support.sqlstore.query.LogHelperQueryExecute;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.JQLC;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.ParameterTable;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;

public class QueryImpl
implements Query {
    private Class candidateClass;
    private String filterExpression;
    private String importDeclarations;
    private String parameterDeclarations;
    private String variableDeclarations;
    private String orderingSpecification;
    private String resultExpression;
    private boolean compiled = false;
    private transient PersistenceManager pm;
    private transient Collection candidateCollection;
    private transient boolean ignoreCache;
    private transient boolean prefetchEnabled = true;
    private transient JQLC jqlc;
    private transient ParameterTable paramtab;
    private transient boolean createdBySerialization = false;
    protected static final ResourceBundle messages = I18NHelper.loadBundle(QueryImpl.class);
    private static Logger logger = LogHelperQueryExecute.getLogger();

    public QueryImpl(PersistenceManager pm) {
        if (logger.isLoggable(400)) {
            logger.finer("LOG_CreateNewQuery", (Object)this.identity());
        }
        this.pm = pm;
        this.paramtab = new ParameterTable();
        this.ignoreCache = pm.getPersistenceManagerFactory().getIgnoreCache();
    }

    public QueryImpl(PersistenceManager pm, Object compiled) {
        if (logger.isLoggable(400)) {
            logger.finer("LOG_CreateNewQueryFromCompiled", (Object)this.identity(), compiled);
        }
        this.pm = pm;
        if (compiled == null) {
            JDOQueryException ex = new JDOQueryException(I18NHelper.getMessage((ResourceBundle)messages, (String)"query.queryimpl.init.compiledquery.isnull"));
            logger.throwing("query.QueryImpl", "<init>", (Throwable)ex);
            throw ex;
        }
        if (!(compiled instanceof QueryImpl)) {
            JDOQueryException ex = new JDOQueryException(I18NHelper.getMessage((ResourceBundle)messages, (String)"query.queryimpl.init.compiledquery.invalidtype", (String)compiled.getClass().getName()));
            logger.throwing("query.QueryImpl", "<init>", (Throwable)ex);
            throw ex;
        }
        QueryImpl other = (QueryImpl)compiled;
        this.candidateClass = other.candidateClass;
        this.filterExpression = other.filterExpression;
        this.importDeclarations = other.importDeclarations;
        this.parameterDeclarations = other.parameterDeclarations;
        this.variableDeclarations = other.variableDeclarations;
        this.orderingSpecification = other.orderingSpecification;
        this.resultExpression = other.resultExpression;
        this.ignoreCache = other.ignoreCache;
        this.prefetchEnabled = other.prefetchEnabled;
        this.candidateCollection = null;
        if (other.paramtab != null) {
            this.jqlc = other.jqlc;
            this.paramtab = new ParameterTable(other.paramtab);
            this.compiled = other.compiled;
        } else {
            this.jqlc = null;
            this.paramtab = new ParameterTable();
            this.compiled = false;
        }
    }

    public QueryImpl(PersistenceManager pm, Class candidateClass) {
        this(pm);
        this.setClass(candidateClass);
    }

    public QueryImpl(PersistenceManager pm, Class candidateClass, Collection candidateCollection) {
        this(pm);
        this.setClass(candidateClass);
        this.setCandidates(candidateCollection);
    }

    public QueryImpl(PersistenceManager pm, Class candidateClass, String filter) {
        this(pm);
        this.setClass(candidateClass);
        this.setFilter(filter);
    }

    public QueryImpl(PersistenceManager pm, Class candidateClass, Collection candidateCollection, String filter) {
        this(pm);
        this.setClass(candidateClass);
        this.setCandidates(candidateCollection);
        this.setFilter(filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClass(Class candidateClass) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.candidateClass = candidateClass;
            this.compiled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCandidates(Collection candidateCollection) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.candidateCollection = candidateCollection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFilter(String filter) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.filterExpression = filter;
            this.compiled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void declareImports(String imports) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.importDeclarations = imports;
            this.compiled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void declareParameters(String parameters) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.parameterDeclarations = parameters;
            this.compiled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void declareVariables(String variables) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.variableDeclarations = variables;
            this.compiled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOrdering(String ordering) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.orderingSpecification = ordering;
            this.compiled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(String result) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.resultExpression = result;
            this.compiled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIgnoreCache(boolean ignoreCache) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.ignoreCache = ignoreCache;
        }
    }

    public boolean getIgnoreCache() {
        return this.ignoreCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrefetchEnabled(boolean prefetchEnabled) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.prefetchEnabled = prefetchEnabled;
            this.compiled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile() {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            if (!this.compiled) {
                if (logger.isLoggable(400)) {
                    logger.finer("LOG_CompileQuery", (Object)this);
                }
                this.jqlc = new JQLC();
                this.jqlc.setClass(this.candidateClass);
                this.jqlc.declareImports(this.importDeclarations);
                this.jqlc.declareParameters(this.parameterDeclarations);
                this.jqlc.declareVariables(this.variableDeclarations);
                this.jqlc.setOrdering(this.orderingSpecification);
                this.jqlc.setResult(this.resultExpression);
                this.jqlc.setFilter(this.filterExpression);
                this.jqlc.setPrefetchEnabled(this.prefetchEnabled);
                this.jqlc.semanticCheck(this.paramtab);
                this.compiled = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.compile();
            ParameterTable params = new ParameterTable(this.paramtab);
            params.initValueHandling();
            params.checkUnboundParams();
            return this.doExecute(params);
        }
    }

    public Object execute(Object p1) {
        Object[] params = new Object[]{p1};
        return this.executeWithArray(params);
    }

    public Object execute(Object p1, Object p2) {
        Object[] params = new Object[]{p1, p2};
        return this.executeWithArray(params);
    }

    public Object execute(Object p1, Object p2, Object p3) {
        Object[] params = new Object[]{p1, p2, p3};
        return this.executeWithArray(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeWithMap(Map parameters) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.compile();
            ParameterTable params = new ParameterTable(this.paramtab);
            params.initValueHandling();
            params.setValues(parameters);
            params.checkUnboundParams();
            return this.doExecute(params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeWithArray(Object[] parameters) {
        ParameterTable parameterTable = this.paramtab;
        synchronized (parameterTable) {
            this.compile();
            ParameterTable params = new ParameterTable(this.paramtab);
            params.initValueHandling();
            params.setValues(parameters);
            params.checkUnboundParams();
            return this.doExecute(params);
        }
    }

    public com.sun.jdo.api.persistence.support.PersistenceManager getPersistenceManager() {
        return this.pm == null ? null : this.pm.getCurrentWrapper();
    }

    public void clearPersistenceManager() {
        this.pm = null;
        this.candidateCollection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doExecute(ParameterTable params) {
        ArrayList result = null;
        RetrieveDesc rd = null;
        try {
            this.pm.acquireExclusiveLock();
        }
        catch (NullPointerException npe) {
            String key = this.createdBySerialization ? "query.queryimpl.doexecute.notboundtopm" : "query.queryimpl.doexecute.pmclosed";
            JDOQueryException ex = new JDOQueryException(I18NHelper.getMessage((ResourceBundle)messages, (String)key));
            logger.throwing("query.QueryImpl", "compile", (Throwable)ex);
            throw ex;
        }
        try {
            this.checkCandidates();
            rd = this.jqlc.codeGen(this.pm, params);
            this.flush();
            if (logger.isLoggable(400)) {
                logger.finer("LOG_ExecuteQuery", (Object)this, (Object)params.getValues());
            }
            result = rd != null ? this.pm.retrieve(rd, params.getValueFetcher()) : new ArrayList();
        }
        finally {
            this.pm.releaseExclusiveLock();
        }
        return result;
    }

    private void checkCandidates() {
        if (this.candidateCollection == null && this.candidateClass != null) {
            this.candidateCollection = this.pm.getExtent(this.candidateClass, false);
        } else {
            this.jqlc.checkCandidates(this.candidateClass, this.candidateCollection);
        }
    }

    private void flush() {
        Transaction tx = this.pm.currentTransaction();
        if (tx != null && tx.isActive() && !tx.getOptimistic() && !this.ignoreCache) {
            this.pm.internalFlush();
        }
    }

    public String toString() {
        StringBuffer repr = new StringBuffer();
        repr.append("QueryImpl(");
        repr.append("candidateClass: ");
        repr.append(this.candidateClass);
        if (this.importDeclarations != null) {
            repr.append(", imports: ");
            repr.append(this.importDeclarations);
        }
        if (this.parameterDeclarations != null) {
            repr.append(", parameters: ");
            repr.append(this.parameterDeclarations);
        }
        if (this.variableDeclarations != null) {
            repr.append(", variables: ");
            repr.append(this.variableDeclarations);
        }
        if (this.filterExpression != null) {
            repr.append(", filter: ");
            repr.append(this.filterExpression);
        }
        if (this.orderingSpecification != null) {
            repr.append(", ordering: ");
            repr.append(this.orderingSpecification);
        }
        if (this.resultExpression != null) {
            repr.append(", result: ");
            repr.append(this.resultExpression);
        }
        repr.append(", prefetchEnabled: ");
        repr.append(this.prefetchEnabled);
        repr.append(", identity: ");
        repr.append(this.identity());
        repr.append(")");
        return repr.toString();
    }

    private String identity() {
        return "QueryImpl@" + System.identityHashCode(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.paramtab = new ParameterTable();
        this.createdBySerialization = true;
    }
}

