/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.asm;

import java.io.DataOutputStream;
import java.io.IOException;
import org.glassfish.rmic.tools.asm.ConstantPool;
import org.glassfish.rmic.tools.asm.ConstantPoolData;
import org.glassfish.rmic.tools.java.Environment;

final class NumberConstantData
extends ConstantPoolData {
    Number num;

    NumberConstantData(ConstantPool tab, Number num) {
        this.num = num;
    }

    @Override
    void write(Environment env, DataOutputStream out, ConstantPool tab) throws IOException {
        if (this.num instanceof Integer) {
            out.writeByte(3);
            out.writeInt(this.num.intValue());
        } else if (this.num instanceof Long) {
            out.writeByte(5);
            out.writeLong(this.num.longValue());
        } else if (this.num instanceof Float) {
            out.writeByte(4);
            out.writeFloat(this.num.floatValue());
        } else if (this.num instanceof Double) {
            out.writeByte(6);
            out.writeDouble(this.num.doubleValue());
        }
    }

    @Override
    int order() {
        return this.width() == 1 ? 0 : 3;
    }

    @Override
    int width() {
        return this.num instanceof Double || this.num instanceof Long ? 2 : 1;
    }
}

