/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Hyperlink;
import com.sun.webui.jsf.renderkit.html.AbstractRenderer;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIParameter;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.FacesEvent;
import java.io.IOException;
import java.util.ArrayList;

public class HyperlinkRenderer
extends AbstractRenderer {
    private static final String[] BOOLEAN_ATTRIBUTES = new String[]{"disabled"};
    private static final String[] INT_ATTRIBUTES = new String[]{"tabIndex"};
    private static final String[] STRING_ATTRIBUTES = new String[]{"onBlur", "onFocus", "onDblClick", "onKeyDown", "onKeyPress", "onMouseUp", "onKeyUp", "onMouseDown", "onMouseMove", "onMouseOut", "onMouseOver"};
    private static final String PARAM_ERROR = "Hyperlink UIParameter child attribute name and/or value not set, id = ";

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        Hyperlink link = (Hyperlink)component;
        if (HyperlinkRenderer.isSubmitLink(link)) {
            String paramId = this.getSubmittedParameterId(context, component);
            String value = (String)context.getExternalContext().getRequestParameterMap().get(paramId);
            if (value == null || !value.equals(component.getClientId(context))) {
                return;
            }
            link.queueEvent((FacesEvent)new ActionEvent((UIComponent)link));
        }
    }

    protected String getSubmittedParameterId(FacesContext context, UIComponent component) {
        return component.getClientId(context) + "_submittedField";
    }

    @Override
    protected void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    @Override
    protected void renderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    @Override
    protected void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        this.renderLink(context, component, writer);
    }

    protected void finishRenderAttributes(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Hyperlink link = (Hyperlink)component;
        String label = ConversionUtilities.convertValueToString(component, link.getText());
        if (label != null) {
            writer.writeText((Object)label, null);
        }
    }

    protected void renderLink(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        Hyperlink link = (Hyperlink)component;
        if (!link.isDisabled()) {
            writer.startElement("a", (UIComponent)link);
        } else {
            writer.startElement("span", (UIComponent)link);
        }
        String label = ConversionUtilities.convertValueToString(component, link.getText());
        String url = link.getUrl();
        String target = link.getTarget();
        String tooltip = link.getToolTip();
        String onclick = link.getOnClick();
        String urlLang = link.getUrlLang();
        String sb = this.getStyles(context, (UIComponent)link);
        this.addCoreAttributes(context, component, writer, sb);
        this.addIntegerAttributes(context, component, writer, INT_ATTRIBUTES);
        HyperlinkRenderer.addStringAttributes(context, component, writer, STRING_ATTRIBUTES);
        if (!link.isDisabled()) {
            this.addBooleanAttributes(context, component, writer, BOOLEAN_ATTRIBUTES);
            if (url != null) {
                if (url.startsWith("#") || url.startsWith("mailto:") || url.startsWith("javascript:")) {
                    writer.writeURIAttribute("href", (Object)url, "url");
                } else {
                    url = this.getCorrectURL(context, (UIComponent)link, url);
                    RenderingUtilities.renderURLAttribute(context, writer, component, "href", url, "url");
                }
                if (onclick != null) {
                    writer.writeAttribute("onclick", (Object)onclick, "onclick");
                }
            } else {
                UIComponent form = ComponentUtilities.getForm(context, component);
                if (form != null) {
                    ArrayList<String> params = new ArrayList<String>();
                    for (UIComponent kid : component.getChildren()) {
                        if (!(kid instanceof UIParameter)) continue;
                        String name = (String)kid.getAttributes().get("name");
                        String value = (String)kid.getAttributes().get("value");
                        if (name == null || value == null) {
                            HyperlinkRenderer.log(PARAM_ERROR + kid.getId());
                            continue;
                        }
                        params.add(name);
                        params.add(value);
                    }
                    String formClientId = form.getClientId(context);
                    StringBuilder buff = new StringBuilder();
                    buff.append(JavaScriptUtilities.renderCalls(onclick, JavaScriptUtilities.renderCall("hyperlink_submit", "this", formClientId, params)));
                    writer.writeAttribute("onclick", (Object)buff.toString(), null);
                    writer.writeAttribute("href", (Object)"#", null);
                }
            }
            if (null != target) {
                writer.writeAttribute("target", (Object)target, null);
            }
            if (null != tooltip) {
                writer.writeAttribute("title", (Object)tooltip, null);
            }
            if (null != urlLang) {
                writer.writeAttribute("hreflang", (Object)urlLang, "urlLang");
            }
        }
        this.finishRenderAttributes(context, component, writer);
        this.renderChildren(context, component);
        if (!link.isDisabled()) {
            writer.endElement("a");
        } else {
            writer.endElement("span");
        }
    }

    protected void renderChildren(FacesContext context, UIComponent component) throws IOException {
        super.encodeChildren(context, component);
    }

    protected String getStyles(FacesContext context, UIComponent component) {
        Hyperlink link = (Hyperlink)component;
        StringBuilder sb = new StringBuilder();
        Theme theme = ThemeUtilities.getTheme(context);
        if (link.isDisabled()) {
            sb.append(" ");
            sb.append(theme.getStyleClass("LINK_DISABLED"));
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    protected String getCorrectURL(FacesContext context, UIComponent component, String url) {
        if (url == null) {
            return null;
        }
        return context.getApplication().getViewHandler().getResourceURL(context, url);
    }

    private static boolean isSubmitLink(Hyperlink h) {
        return h.getUrl() == null;
    }

    private static void log(String msg) {
        if (LogUtil.fineEnabled(HyperlinkRenderer.class)) {
            LogUtil.fine(HyperlinkRenderer.class, msg);
        }
    }
}

