/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.math.BigInteger;
import java.util.Comparator;
import org.assertj.core.annotation.CheckReturnValue;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.NumberAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.internal.BigIntegers;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.util.VisibleForTesting;

public class AbstractBigIntegerAssert<SELF extends AbstractBigIntegerAssert<SELF>>
extends AbstractComparableAssert<SELF, BigInteger>
implements NumberAssert<SELF, BigInteger> {
    @VisibleForTesting
    BigIntegers bigIntegers = BigIntegers.instance();

    protected AbstractBigIntegerAssert(BigInteger actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public SELF isZero() {
        this.bigIntegers.assertIsZero(this.info, (BigInteger)this.actual);
        return (SELF)((AbstractBigIntegerAssert)this.myself);
    }

    @Override
    public SELF isNotZero() {
        this.bigIntegers.assertIsNotZero(this.info, (BigInteger)this.actual);
        return (SELF)((AbstractBigIntegerAssert)this.myself);
    }

    @Override
    public SELF isOne() {
        this.bigIntegers.assertIsOne(this.info, (BigInteger)this.actual);
        return (SELF)((AbstractBigIntegerAssert)this.myself);
    }

    @Override
    public SELF isPositive() {
        this.bigIntegers.assertIsPositive(this.info, (BigInteger)this.actual);
        return (SELF)((AbstractBigIntegerAssert)this.myself);
    }

    @Override
    public SELF isNegative() {
        this.bigIntegers.assertIsNegative(this.info, (BigInteger)this.actual);
        return (SELF)((AbstractBigIntegerAssert)this.myself);
    }

    @Override
    public SELF isNotNegative() {
        this.bigIntegers.assertIsNotNegative(this.info, (BigInteger)this.actual);
        return (SELF)((AbstractBigIntegerAssert)this.myself);
    }

    @Override
    public SELF isNotPositive() {
        this.bigIntegers.assertIsNotPositive(this.info, (BigInteger)this.actual);
        return (SELF)((AbstractBigIntegerAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(BigInteger expected, Offset<BigInteger> offset) {
        this.bigIntegers.assertIsCloseTo(this.info, (BigInteger)this.actual, expected, offset);
        return (SELF)((AbstractBigIntegerAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(BigInteger expected, Offset<BigInteger> offset) {
        this.bigIntegers.assertIsNotCloseTo(this.info, (BigInteger)this.actual, expected, offset);
        return (SELF)((AbstractBigIntegerAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(BigInteger expected, Percentage percentage) {
        this.bigIntegers.assertIsCloseToPercentage(this.info, (BigInteger)this.actual, expected, percentage);
        return (SELF)((AbstractBigIntegerAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(BigInteger expected, Percentage percentage) {
        this.bigIntegers.assertIsNotCloseToPercentage(this.info, (BigInteger)this.actual, expected, percentage);
        return (SELF)((AbstractBigIntegerAssert)this.myself);
    }

    @Override
    public SELF isBetween(BigInteger start, BigInteger end) {
        this.bigIntegers.assertIsBetween(this.info, (BigInteger)this.actual, start, end);
        return (SELF)((AbstractBigIntegerAssert)this.myself);
    }

    @Override
    public SELF isStrictlyBetween(BigInteger start, BigInteger end) {
        this.bigIntegers.assertIsStrictlyBetween(this.info, (BigInteger)this.actual, start, end);
        return (SELF)((AbstractBigIntegerAssert)this.myself);
    }

    public SELF isEqualTo(String expected) {
        return (SELF)((AbstractBigIntegerAssert)this.isEqualTo(new BigInteger(expected)));
    }

    public SELF isEqualTo(int expected) {
        return (SELF)((AbstractBigIntegerAssert)this.isEqualTo(new BigInteger(Integer.toString(expected))));
    }

    public SELF isEqualTo(long expected) {
        return (SELF)((AbstractBigIntegerAssert)this.isEqualTo(new BigInteger(Long.toString(expected))));
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super BigInteger> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super BigInteger> customComparator, String customComparatorDescription) {
        this.bigIntegers = new BigIntegers(new ComparatorBasedComparisonStrategy(customComparator, customComparatorDescription));
        return (SELF)((AbstractBigIntegerAssert)super.usingComparator(customComparator, customComparatorDescription));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        this.bigIntegers = BigIntegers.instance();
        return (SELF)((AbstractBigIntegerAssert)super.usingDefaultComparator());
    }
}

