/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.preferences.ui;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edapt.history.presentation.HistoryEditorPlugin;
import org.eclipse.emf.edapt.history.util.HistoryUtils;
import org.eclipse.emf.edapt.internal.common.FileUtils;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;

public final class ResourcePreferences {
    private static final IPath STORE_LOCATION;
    private static final Map<URI, IPersistentPreferenceStore> preferenceStores;

    static {
        preferenceStores = new HashMap<URI, IPersistentPreferenceStore>();
        IPath stateLocation = HistoryEditorPlugin.getPlugin().getStateLocation();
        STORE_LOCATION = stateLocation.append("resources");
    }

    private ResourcePreferences() {
    }

    public static synchronized IPreferenceStore getPreferences(EditingDomain editingDomain) {
        ResourceSet rset = editingDomain.getResourceSet();
        Resource resource = ResourcePreferences.getHistoryOrMainResource(rset);
        return ResourcePreferences.getPreferences(rset.getURIConverter().normalize(resource.getURI()));
    }

    private static Resource getHistoryOrMainResource(ResourceSet rset) {
        Resource result = HistoryUtils.getHistoryResource((ResourceSet)rset);
        if (result == null) {
            result = (Resource)rset.getResources().get(0);
        }
        return result;
    }

    public static synchronized IPreferenceStore getPreferences(URI uri) {
        IPreferenceStore result = (IPreferenceStore)preferenceStores.get(uri);
        if (result == null) {
            result = ResourcePreferences.createPreferenceStore(uri);
        }
        return result;
    }

    private static IPreferenceStore createPreferenceStore(URI uri) {
        IPath storeLocation;
        try {
            storeLocation = STORE_LOCATION.append(String.valueOf(URLEncoder.encode(uri.toString(), "UTF-8")) + ".prefs");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("UTF-8 encoding not supported");
        }
        File storeFile = storeLocation.toFile();
        PreferenceStore result = new PreferenceStore(storeFile.getAbsolutePath());
        if (storeFile.exists()) {
            try {
                result.load();
            }
            catch (IOException e) {
                HistoryEditorPlugin.INSTANCE.log(e);
            }
        }
        try {
            ResourcePreferences.register((IPersistentPreferenceStore)result, uri);
        }
        catch (CoreException e) {
            HistoryEditorPlugin.getPlugin().getLog().log(e.getStatus());
        }
        return result;
    }

    private static void register(IPersistentPreferenceStore store, URI uri) throws CoreException {
        if (preferenceStores.isEmpty()) {
            ResourcePreferences.installWorkspaceSaveParticipant();
        }
        preferenceStores.put(uri, store);
    }

    private static void installWorkspaceSaveParticipant() throws CoreException {
        ResourcesPlugin.getWorkspace().addSaveParticipant(HistoryEditorPlugin.getPlugin().getSymbolicName(), new ISaveParticipant(){

            public void saving(ISaveContext context) throws CoreException {
                ResourcePreferences.savePreferenceStores();
            }

            public void prepareToSave(ISaveContext context) throws CoreException {
            }

            public void doneSaving(ISaveContext context) {
            }

            public void rollback(ISaveContext context) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void savePreferenceStores() throws CoreException {
        Class<ResourcePreferences> clazz = ResourcePreferences.class;
        synchronized (ResourcePreferences.class) {
            HashMap<URI, IPersistentPreferenceStore> toSave = new HashMap<URI, IPersistentPreferenceStore>(preferenceStores);
            // ** MonitorExit[var1] (shouldn't be in output)
            Iterator iter = toSave.entrySet().iterator();
            while (iter.hasNext()) {
                if (((IPersistentPreferenceStore)iter.next().getValue()).needsSaving()) continue;
                iter.remove();
            }
            if (!toSave.isEmpty()) {
                ArrayList<URI> failed = new ArrayList<URI>(toSave.size());
                File storeDirectory = STORE_LOCATION.toFile();
                if (storeDirectory.exists() && !storeDirectory.isDirectory()) {
                    throw new CoreException((IStatus)new Status(4, HistoryEditorPlugin.getPlugin().getSymbolicName(), String.format("Cannot create preference store. Path exists but is not a directory: %s", STORE_LOCATION)));
                }
                if (!storeDirectory.exists()) {
                    storeDirectory.mkdirs();
                }
                for (Map.Entry next : toSave.entrySet()) {
                    try {
                        ((IPersistentPreferenceStore)next.getValue()).save();
                    }
                    catch (IOException e) {
                        HistoryEditorPlugin.INSTANCE.log(e);
                        failed.add((URI)next.getKey());
                    }
                }
                if (!failed.isEmpty()) {
                    throw new CoreException((IStatus)new Status(4, HistoryEditorPlugin.getPlugin().getSymbolicName(), String.format("Failed to save resource preferences: %s.", failed)));
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteAll() {
        Class<ResourcePreferences> clazz = ResourcePreferences.class;
        synchronized (ResourcePreferences.class) {
            preferenceStores.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            FileUtils.deleteContents((File)STORE_LOCATION.toFile());
            return;
        }
    }
}

