/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.internal.migration.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Model;
import org.eclipse.emf.edapt.spi.migration.Type;

public class LazyExtentMap
implements Map<EClass, Set<Instance>> {
    private HashMap<EClass, Set<Instance>> delegate;
    private final Model model;

    public LazyExtentMap(Model model) {
        this.model = model;
    }

    @Override
    public Set<Instance> get(Object arg0) {
        if (this.delegate == null) {
            this.init();
        }
        return this.delegate.get(arg0);
    }

    private void init() {
        this.delegate = new HashMap();
        for (Type type : this.model.getTypes()) {
            EClass clazz = type.getEClass();
            UniqueEList types = new UniqueEList((Collection)clazz.getEAllSuperTypes());
            types.add((Object)clazz);
            for (EClass t : types) {
                Set<Instance> instances = this.delegate.get(t);
                if (instances == null) {
                    instances = new HashSet<Instance>();
                    this.delegate.put(t, instances);
                }
                instances.addAll((Collection<Instance>)type.getInstances());
            }
        }
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    public Object clone() {
        return this.delegate.clone();
    }

    @Override
    public boolean containsKey(Object arg0) {
        return this.delegate.containsKey(arg0);
    }

    @Override
    public boolean containsValue(Object arg0) {
        return this.delegate.containsValue(arg0);
    }

    @Override
    public Set<Map.Entry<EClass, Set<Instance>>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object arg0) {
        return this.delegate.equals(arg0);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Set<EClass> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Set<Instance> put(EClass arg0, Set<Instance> arg1) {
        return this.delegate.put(arg0, arg1);
    }

    @Override
    public void putAll(Map<? extends EClass, ? extends Set<Instance>> arg0) {
        this.delegate.putAll(arg0);
    }

    @Override
    public Set<Instance> remove(Object arg0) {
        return this.delegate.remove(arg0);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public Collection<Set<Instance>> values() {
        return this.delegate.values();
    }
}

