/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.segments.multi;

import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDMRSegmentExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDomainExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsExpandingFailedException;
import org.eclipse.emfforms.view.spi.multisegment.model.VMultiDomainModelReferenceSegment;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(name="MultiSegmentExpander")
public class MultiSegmentExpander
implements EMFFormsDMRSegmentExpander {
    private ReportService reportService;
    private EMFFormsDomainExpander domainExpander;
    private ServiceReference<EMFFormsDomainExpander> emfFormsDomainExpanderServiceReference;
    private BundleContext bundleContext;

    @Reference(unbind="-")
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        if (this.emfFormsDomainExpanderServiceReference != null) {
            bundleContext.ungetService(this.emfFormsDomainExpanderServiceReference);
            this.domainExpander = null;
        }
    }

    private EMFFormsDomainExpander getEMFFormsDomainExpander() {
        if (this.domainExpander == null) {
            this.emfFormsDomainExpanderServiceReference = this.bundleContext.getServiceReference(EMFFormsDomainExpander.class);
            if (this.emfFormsDomainExpanderServiceReference == null) {
                throw new IllegalStateException("No EMFFormsDomainExpander available!");
            }
            this.domainExpander = (EMFFormsDomainExpander)this.bundleContext.getService(this.emfFormsDomainExpanderServiceReference);
        }
        return this.domainExpander;
    }

    void setEMFFormsDomainExpander(EMFFormsDomainExpander domainExpander) {
        this.domainExpander = domainExpander;
    }

    public Optional<EObject> prepareDomainObject(VDomainModelReferenceSegment segment, EObject domainObject) throws EMFFormsExpandingFailedException {
        Assert.create((Object)segment).notNull().ofClass(VMultiDomainModelReferenceSegment.class);
        Assert.create((Object)domainObject).notNull();
        VMultiDomainModelReferenceSegment multiSegment = (VMultiDomainModelReferenceSegment)segment;
        EStructuralFeature structuralFeature = domainObject.eClass().getEStructuralFeature(multiSegment.getDomainModelFeature());
        if (structuralFeature == null) {
            throw new EMFFormsExpandingFailedException(String.format("The given domain object does not contain the segment's feature. The segment was %1$s. The domain object was %2$s.", segment, domainObject));
        }
        if (!EReference.class.isInstance(structuralFeature)) {
            throw new EMFFormsExpandingFailedException(String.format("The feature described by the given segment must be an EReference. The segment was %1$s.", segment));
        }
        EReference reference = (EReference)structuralFeature;
        if (!reference.isMany()) {
            throw new EMFFormsExpandingFailedException(String.format("The EReference described by the given multi segment must be a multi reference. The segment was %1$s.", segment));
        }
        EList list = (EList)domainObject.eGet((EStructuralFeature)reference);
        for (EObject childRoot : list) {
            for (VDomainModelReference childDMR : multiSegment.getChildDomainModelReferences()) {
                this.getEMFFormsDomainExpander().prepareDomainObject(childDMR, childRoot);
            }
        }
        return Optional.empty();
    }

    public double isApplicable(VDomainModelReferenceSegment segment) {
        if (segment == null) {
            this.reportService.report(new AbstractReport("The given segment was null.", 2));
            return NOT_APPLICABLE;
        }
        if (VMultiDomainModelReferenceSegment.class.isInstance(segment)) {
            return 5.0;
        }
        return NOT_APPLICABLE;
    }

    public boolean needsToExpandLastSegment() {
        return true;
    }
}

