/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.core.services.view;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.common.TriConsumer;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsContextListener;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewContext;
import org.eclipse.emfforms.spi.core.services.view.RootDomainModelChangeListener;

public class EMFFormsContextTracker {
    private final Map<EMFFormsViewContext, ContextListener> contextListeners = new WeakHashMap<EMFFormsViewContext, ContextListener>();
    private final Function<EMFFormsViewContext, ContextListener> listenerFactory = arg_0 -> ContextListener.new(this, arg_0);
    private final EMFFormsViewContext root;
    private final ReportService reportService;
    private boolean active;
    private Consumer<? super EMFFormsViewContext> initializedHandler;
    private Consumer<? super EMFFormsViewContext> disposedHandler;
    private TriConsumer<? super EMFFormsViewContext, ? super VElement, ? super EMFFormsViewContext> addedHandler;
    private TriConsumer<? super EMFFormsViewContext, ? super VElement, ? super EMFFormsViewContext> removedHandler;
    private Consumer<? super EMFFormsViewContext> domainModelChangedHandler;

    public EMFFormsContextTracker(EMFFormsViewContext context) {
        this.root = context;
        this.reportService = context.getService(ReportService.class);
    }

    public boolean isRoot(EMFFormsViewContext context) {
        return context == this.root;
    }

    public EMFFormsContextTracker onContextInitialized(Consumer<? super EMFFormsViewContext> handler) {
        this.initializedHandler = handler;
        return this;
    }

    public EMFFormsContextTracker onContextDisposed(Consumer<? super EMFFormsViewContext> handler) {
        this.disposedHandler = handler;
        return this;
    }

    public EMFFormsContextTracker onDomainModelChanged(Consumer<? super EMFFormsViewContext> handler) {
        this.domainModelChangedHandler = handler;
        return this;
    }

    public EMFFormsContextTracker onChildContextAdded(TriConsumer<? super EMFFormsViewContext, ? super VElement, ? super EMFFormsViewContext> handler) {
        this.addedHandler = handler;
        return this;
    }

    public EMFFormsContextTracker onChildContextRemoved(TriConsumer<? super EMFFormsViewContext, ? super VElement, ? super EMFFormsViewContext> handler) {
        this.removedHandler = handler;
        return this;
    }

    public void open() {
        if (!this.active) {
            this.active = true;
            this.handleChildContextAdded(null, null, this.root);
        }
    }

    public void close() {
        if (this.active) {
            this.active = false;
            try {
                this.contextListeners.values().forEach(ContextListener::dispose);
            }
            finally {
                this.contextListeners.clear();
            }
        }
    }

    private void handleChildContextAdded(EMFFormsViewContext parentContext, VElement parentElement, EMFFormsViewContext childContext) {
        ContextListener listener = this.getListener(childContext);
        listener.addedToParent(true);
        listener.setParentElement(parentElement);
    }

    private ContextListener getListener(EMFFormsViewContext context) {
        return this.contextListeners.computeIfAbsent(context, this.listenerFactory);
    }

    private void handleChildContextRemoved(EMFFormsViewContext parentContext, VElement parentElement, EMFFormsViewContext childContext) {
        ContextListener listener = this.getListener(childContext);
        listener.addedToParent(false);
        listener.setParentElement(null);
    }

    private void notifyContextInitialized(EMFFormsViewContext context) {
        if (this.initializedHandler != null) {
            this.safeAccept(this.initializedHandler, context);
        }
    }

    private void notifyContextDisposed(EMFFormsViewContext context) {
        if (this.disposedHandler != null) {
            this.safeAccept(this.disposedHandler, context);
        }
    }

    private void notifyDomainModelChanged(EMFFormsViewContext context) {
        if (this.domainModelChangedHandler != null) {
            this.safeAccept(this.domainModelChangedHandler, context);
        }
    }

    private void notifyContextAdded(EMFFormsViewContext parent, VElement parentElement, EMFFormsViewContext child) {
        if (this.addedHandler != null) {
            this.safeAccept(this.addedHandler, parent, parentElement, child);
        }
    }

    private void notifyContextRemoved(EMFFormsViewContext parent, VElement parentElement, EMFFormsViewContext child) {
        if (this.removedHandler != null) {
            this.safeAccept(this.removedHandler, parent, parentElement, child);
        }
    }

    private <T> void safeAccept(Consumer<? super T> consumer, T t) {
        try {
            consumer.accept(t);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        catch (LinkageError e) {
            this.handleException(e);
        }
        catch (AssertionError e) {
            this.handleException((Throwable)((Object)e));
        }
    }

    private <T, U, V> void safeAccept(TriConsumer<? super T, ? super U, ? super V> consumer, T t, U u, V v) {
        try {
            consumer.accept(t, u, v);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        catch (LinkageError e) {
            this.handleException(e);
        }
        catch (AssertionError e) {
            this.handleException((Throwable)((Object)e));
        }
    }

    private void handleException(Throwable t) {
        this.reportService.report(new AbstractReport(t, "Unhandled exception in EMFFormsContextTracker call-back"));
    }

    static /* synthetic */ void access$0(EMFFormsContextTracker eMFFormsContextTracker, EMFFormsViewContext eMFFormsViewContext) {
        eMFFormsContextTracker.notifyContextInitialized(eMFFormsViewContext);
    }

    static /* synthetic */ void access$1(EMFFormsContextTracker eMFFormsContextTracker, EMFFormsViewContext eMFFormsViewContext) {
        eMFFormsContextTracker.notifyContextDisposed(eMFFormsViewContext);
    }

    static /* synthetic */ void access$7(EMFFormsContextTracker eMFFormsContextTracker, EMFFormsViewContext eMFFormsViewContext) {
        eMFFormsContextTracker.notifyDomainModelChanged(eMFFormsViewContext);
    }

    private final class ContextListener
    implements EMFFormsContextListener {
        private final RootDomainModelChangeListener domainModelChangeListener = this::domainModelChanged;
        private final Reference<EMFFormsViewContext> context;
        private Reference<VElement> parentElement;
        private boolean addedToParent;

        ContextListener(EMFFormsViewContext context) {
            this.context = new WeakReference<EMFFormsViewContext>(context);
            context.registerEMFFormsContextListener(this);
            context.registerRootDomainModelChangeListener(this.domainModelChangeListener);
        }

        private Optional<EMFFormsViewContext> getContext() {
            return Optional.ofNullable(this.context.get());
        }

        void dispose() {
            this.getContext().ifPresent(ctx -> {
                ctx.unregisterRootDomainModelChangeListener(this.domainModelChangeListener);
                ctx.unregisterEMFFormsContextListener(this);
            });
        }

        @Override
        public void contextInitialised() {
            this.getContext().ifPresent(arg_0 -> EMFFormsContextTracker.access$0(EMFFormsContextTracker.this, arg_0));
        }

        @Override
        public void contextDispose() {
            this.getContext().ifPresent(arg_0 -> EMFFormsContextTracker.access$1(EMFFormsContextTracker.this, arg_0));
        }

        @Override
        public void childContextAdded(VElement parentElement, EMFFormsViewContext childContext) {
            if (EMFFormsContextTracker.this.getListener(childContext).isAddedToParent()) {
                return;
            }
            this.getContext().ifPresent(ctx -> {
                EMFFormsContextTracker.this.notifyContextAdded(ctx, parentElement, childContext);
                EMFFormsContextTracker.this.handleChildContextAdded(ctx, parentElement, childContext);
            });
        }

        @Override
        public void childContextDisposed(EMFFormsViewContext childContext) {
            if (!EMFFormsContextTracker.this.getListener(childContext).isAddedToParent()) {
                return;
            }
            this.getContext().ifPresent(ctx -> {
                VElement parentElement = EMFFormsContextTracker.this.getListener(childContext).getParentElement();
                EMFFormsContextTracker.this.handleChildContextRemoved(ctx, parentElement, childContext);
                EMFFormsContextTracker.this.notifyContextRemoved(ctx, parentElement, childContext);
            });
        }

        void domainModelChanged() {
            this.getContext().ifPresent(arg_0 -> EMFFormsContextTracker.access$7(EMFFormsContextTracker.this, arg_0));
        }

        void addedToParent(boolean added) {
            this.addedToParent = added;
        }

        boolean isAddedToParent() {
            return this.addedToParent;
        }

        VElement getParentElement() {
            return this.parentElement != null ? this.parentElement.get() : null;
        }

        void setParentElement(VElement parentElement) {
            this.parentElement = parentElement != null ? new WeakReference<VElement>(parentElement) : null;
        }
    }
}

