/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ecore.editor.util;

public class ProjectHelper {
    private String projectFullName;

    public ProjectHelper(String projectFullName) {
        this.projectFullName = projectFullName;
    }

    public String getProjectName() {
        if (this.getProjectFullName() == null) {
            return "";
        }
        String[] split = this.getProjectFullName().split("\\.");
        if (split.length <= 0) {
            return "";
        }
        String lastSegment = split[split.length - 1];
        if (lastSegment.toLowerCase().equals("model") && split.length > 1) {
            return split[split.length - 2];
        }
        return lastSegment;
    }

    public String getNSPrefix() {
        int dotIndex = this.projectFullName.lastIndexOf(".");
        if (dotIndex == -1) {
            return this.projectFullName;
        }
        return this.projectFullName.substring(0, dotIndex);
    }

    public String getNSURL() {
        if (!this.projectFullName.contains(".")) {
            return "http://" + this.projectFullName;
        }
        String[] split = this.projectFullName.split("\\.");
        String temp = split[0];
        split[0] = split[1];
        split[1] = temp;
        String result = this.join(split, "/");
        StringBuilder builder = new StringBuilder(result);
        builder.setCharAt(result.indexOf(47), '.');
        result = "http://" + builder;
        return result;
    }

    private String join(String[] r, String d) {
        if (r.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < r.length - 1) {
            sb.append(String.valueOf(r[i]) + d);
            ++i;
        }
        return String.valueOf(sb.toString()) + r[i];
    }

    public String getProjectFullName() {
        return this.projectFullName;
    }

    public void setProjectFullName(String projectFullName) {
        this.projectFullName = projectFullName;
    }
}

