/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.rulerepository.tooling.merge;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.spi.model.VAttachment;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.rule.model.AndCondition;
import org.eclipse.emf.ecp.view.spi.rule.model.Condition;
import org.eclipse.emf.ecp.view.spi.rule.model.OrCondition;
import org.eclipse.emf.ecp.view.spi.rule.model.Rule;
import org.eclipse.emf.ecp.view.spi.rule.model.RuleFactory;
import org.eclipse.emfforms.spi.rulerepository.model.MergeType;
import org.eclipse.emfforms.spi.rulerepository.model.VRuleEntry;
import org.eclipse.emfforms.spi.rulerepository.model.VRuleRepository;

public final class MergeHelper {
    private MergeHelper() {
    }

    public static void merge(VRuleRepository ruleRepository) {
        LinkedHashMap<VElement, OrCondition> initialMerged = new LinkedHashMap<VElement, OrCondition>();
        for (VRuleEntry ruleEntry : ruleRepository.getRuleEntries()) {
            for (VElement vElement : ruleEntry.getElements()) {
                if (vElement.eIsProxy()) continue;
                MergeHelper.mergeRules(vElement, ruleEntry, initialMerged);
            }
        }
    }

    private static void mergeRules(VElement vElement, VRuleEntry ruleEntry, Map<VElement, OrCondition> initialMerged) {
        AndCondition and;
        Rule existingRule = MergeHelper.getExistingRule((EList<VAttachment>)vElement.getAttachments());
        Rule newRule = (Rule)EcoreUtil.copy((EObject)ruleEntry.getRule());
        if (existingRule == null) {
            vElement.getAttachments().add((Object)newRule);
            return;
        }
        if (!initialMerged.containsKey(vElement)) {
            and = RuleFactory.eINSTANCE.createAndCondition();
            OrCondition or = RuleFactory.eINSTANCE.createOrCondition();
            and.getConditions().add((Object)or);
            or.getConditions().add((Object)existingRule.getCondition());
            existingRule.setCondition((Condition)and);
            initialMerged.put(vElement, or);
        }
        if (ruleEntry.getMergeType() == MergeType.OR) {
            OrCondition or = initialMerged.get(vElement);
            or.getConditions().add((Object)newRule.getCondition());
        } else if (ruleEntry.getMergeType() == MergeType.AND) {
            and = (AndCondition)existingRule.getCondition();
            and.getConditions().add((Object)newRule.getCondition());
        }
    }

    private static Rule getExistingRule(EList<VAttachment> attachments) {
        for (VAttachment attachment : attachments) {
            if (!Rule.class.isInstance(attachment)) continue;
            return (Rule)Rule.class.cast(attachment);
        }
        return null;
    }
}

