/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.wizards;

import java.util.ArrayList;
import org.eclipse.emf.ecp.core.ECPProvider;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.internal.ui.Activator;
import org.eclipse.emf.ecp.internal.ui.Messages;
import org.eclipse.emf.ecp.spi.common.ui.ECPWizard;
import org.eclipse.emf.ecp.ui.common.CreateProjectComposite;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CreateProjectWizard
extends ECPWizard<CreateProjectComposite> {
    public boolean performFinish() {
        return true;
    }

    public void addPages() {
        super.addPages();
        ArrayList<ECPProvider> providers = new ArrayList<ECPProvider>();
        for (ECPProvider provider : ECPUtil.getECPProviderRegistry().getProviders()) {
            if (!provider.hasCreateProjectWithoutRepositorySupport()) continue;
            providers.add(provider);
        }
        WizardPage wp = new WizardPage("CreateProject"){

            public void createControl(Composite parent) {
                Composite composite = ((CreateProjectComposite)CreateProjectWizard.this.getCompositeProvider()).createUI(parent);
                ((CreateProjectComposite)CreateProjectWizard.this.getCompositeProvider()).setListener(new CreateProjectComposite.CreateProjectChangeListener(){

                    @Override
                    public void providerChanged(ECPProvider provider) {
                    }

                    @Override
                    public void projectNameChanged(String projectName) {
                        if (projectName != null && ECPUtil.getECPProjectManager().getProject(projectName) != null) {
                            this.setErrorMessage("A project with name " + projectName + " already exists in the workspace.");
                        } else {
                            this.setErrorMessage(null);
                        }
                    }

                    @Override
                    public void completeStatusChanged(boolean status) {
                        this.setPageComplete(status);
                    }
                });
                this.setPageComplete(false);
                this.setControl((Control)composite);
            }
        };
        this.addPage((IWizardPage)wp);
        String title = Messages.CreateProjectWizard_PageTitle_CreateProject;
        String message = Messages.CreateProjectWizard_PageMessage_SelectProviderAndSetName;
        if (providers.size() == 1) {
            message = Messages.CreateProjectWizard_PageMessage_SetProjectName;
        }
        wp.setTitle(title);
        wp.setImageDescriptor(Activator.getImageDescriptor("icons/checkout_project_wiz.png"));
        wp.setMessage(message);
        this.setWindowTitle(title);
    }
}

