/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.cdo.internal.core;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.server.CDOServerBrowser;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.workspace.InternalCDOWorkspace;
import org.eclipse.emf.ecp.cdo.internal.core.CDOProjectData;
import org.eclipse.emf.ecp.cdo.internal.core.CDOProvider;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.ecp.cdo.core";
    private static Activator instance;
    private CDOServerBrowser serverBrowser;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        instance = this;
        this.serverBrowser = new CDOServerBrowserImpl(null);
        try {
            this.serverBrowser.setPort(7778);
            this.serverBrowser.activate();
        }
        catch (Exception e) {
            Activator.log(e.getMessage());
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.serverBrowser.deactivate();
        this.serverBrowser = null;
        if (CDOProvider.getInstance() != null) {
            CDOProvider.getInstance().dispose();
        }
        instance = null;
        super.stop(bundleContext);
    }

    public static Activator getInstance() {
        return instance;
    }

    public static void log(String message) {
        instance.getLog().log((IStatus)new Status(1, PLUGIN_ID, message));
    }

    public static void log(IStatus status) {
        instance.getLog().log(status);
    }

    public static String log(Throwable t) {
        IStatus status = Activator.getStatus(t);
        Activator.log(status);
        return status.getMessage();
    }

    public static IStatus getStatus(Throwable t) {
        if (t instanceof CoreException) {
            CoreException coreException = (CoreException)t;
            return coreException.getStatus();
        }
        String msg = t.getLocalizedMessage();
        if (msg == null || msg.length() == 0) {
            msg = t.getClass().getName();
        }
        return new Status(4, PLUGIN_ID, msg, t);
    }

    private final class CDOServerBrowserImpl
    extends CDOServerBrowser {
        private CDOServerBrowserImpl(Map<String, InternalRepository> repositories) {
            super(repositories);
        }

        protected Set<String> getRepositoryNames() {
            HashSet<String> names = new HashSet<String>();
            for (ECPProject project : ECPUtil.getECPProjectManager().getProjects()) {
                CDOProjectData projectData;
                InternalCDOWorkspace workspace;
                if (!project.getProvider().getName().equals("org.eclipse.emf.ecp.cdo.provider") || (workspace = (InternalCDOWorkspace)(projectData = CDOProvider.getProjectData((InternalProject)project)).getWorkspace()) == null) continue;
                InternalRepository localRepository = workspace.getLocalRepository();
                names.add(localRepository.getName());
            }
            return names;
        }

        protected InternalRepository getRepository(String name) {
            for (ECPProject project : ECPUtil.getECPProjectManager().getProjects()) {
                InternalRepository localRepository;
                CDOProjectData projectData;
                InternalCDOWorkspace workspace;
                if (!project.getProvider().getName().equals("org.eclipse.emf.ecp.cdo.provider") || (workspace = (InternalCDOWorkspace)(projectData = CDOProvider.getProjectData((InternalProject)project)).getWorkspace()) == null || !(localRepository = workspace.getLocalRepository()).getName().equals(name)) continue;
                return localRepository;
            }
            return null;
        }
    }
}

