/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emf2web.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecp.emf2web.controller.xtend.GenerationInfo;
import org.eclipse.emf.ecp.emf2web.exporter.DialogToggleInteraction;
import org.eclipse.emf.ecp.emf2web.exporter.GenerationExporter;
import org.eclipse.emf.ecp.emf2web.exporter.UserInteraction;
import org.eclipse.emf.ecp.emf2web.ui.messages.Messages;
import org.eclipse.emf.ecp.emf2web.ui.wizard.SelectLocationPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class ExportSchemasWizard
extends Wizard
implements PropertyChangeListener {
    private final Collection<? extends GenerationInfo> generationInfos;
    private final GenerationExporter exporter;

    public ExportSchemasWizard(Collection<? extends GenerationInfo> generationInfos, GenerationExporter exporter, URI locationProposal) {
        this.setWindowTitle(Messages.getString("ExportSchemasWizard.WindowTitle"));
        this.generationInfos = generationInfos;
        this.exporter = exporter;
        if (locationProposal == null) {
            locationProposal = URI.createFileURI((String)System.getProperty("user.home", ""));
        }
        for (GenerationInfo generationInfo : generationInfos) {
            URI proposal = locationProposal.appendSegment(generationInfo.getNameProposal());
            generationInfo.setLocation(proposal);
            generationInfo.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void addPages() {
        for (GenerationInfo generationInfo : this.generationInfos) {
            this.addPage((IWizardPage)new SelectLocationPage(generationInfo));
        }
    }

    public boolean performFinish() {
        try {
            this.exporter.export(this.generationInfos, (UserInteraction)new DialogToggleInteraction());
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString("ExportSchemasWizard.DialogTitle_Success"), (String)Messages.getString("ExportSchemasWizard.DialogMessage_Success"));
            return true;
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("ExportSchemasWizard.DialogTitle_Error"), (String)e.getMessage());
            return false;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        for (SelectLocationPage page : this.getNotVisitedLocationPages()) {
            GenerationInfo generationInfo = page.getGenerationInfo();
            generationInfo.removePropertyChangeListener((PropertyChangeListener)this);
            if ("location".equals(event.getPropertyName())) {
                URI newLocation = this.getNewLocationProposal((URI)URI.class.cast(event.getNewValue()), generationInfo.getNameProposal());
                generationInfo.setLocation(newLocation);
            }
            if ("wrap".equals(event.getPropertyName())) {
                generationInfo.setWrap(((Boolean)Boolean.class.cast(event.getNewValue())).booleanValue());
            }
            generationInfo.addPropertyChangeListener((PropertyChangeListener)this);
            page.getBindingContext().updateTargets();
        }
    }

    private Set<SelectLocationPage> getNotVisitedLocationPages() {
        HashSet<SelectLocationPage> locationPages = new HashSet<SelectLocationPage>();
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            this.addNotAlreadyVisibleLocationPage(page, locationPages);
            ++n2;
        }
        return locationPages;
    }

    private void addNotAlreadyVisibleLocationPage(IWizardPage page, Set<SelectLocationPage> locationPages) {
        SelectLocationPage locationPage;
        if (SelectLocationPage.class.isInstance(page) && !(locationPage = (SelectLocationPage)((Object)SelectLocationPage.class.cast(page))).wasAlreadyVisible()) {
            locationPages.add(locationPage);
        }
    }

    private URI getNewLocationProposal(URI location, String fileName) {
        URI result = location;
        result = result.trimSegments(1);
        result = result.appendSegment(fileName).trimFileExtension();
        if (location.fileExtension() != null) {
            result = result.appendFileExtension(location.fileExtension());
        }
        return result;
    }
}

