/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.handler;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.ui.view.ECPRendererException;
import org.eclipse.emf.ecp.ui.view.swt.ECPSWTViewRenderer;
import org.eclipse.emf.ecp.view.internal.editor.handler.EStructuralFeatureContentProvider;
import org.eclipse.emf.ecp.view.internal.editor.handler.SegmentGenerator;
import org.eclipse.emf.ecp.view.internal.editor.handler.SelectFeaturePathWizardPage;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContextFactory;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.editor.controls.EStructuralFeatureSelectionValidator;
import org.eclipse.emf.ecp.view.spi.editor.controls.SegmentIdeDescriptor;
import org.eclipse.emf.ecp.view.spi.editor.controls.SelectedFeatureViewService;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VFeatureDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.model.util.SegmentResolvementUtil;
import org.eclipse.emf.ecp.view.spi.provider.ViewProviderHelper;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emfforms.common.internal.validation.ValidationServiceImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class CreateSegmentDmrWizard
extends Wizard {
    private final EClass rootEClass;
    private final VDomainModelReference existingDMR;
    private final EStructuralFeatureSelectionValidator selectionValidator;
    private final SegmentGenerator segmentGenerator;
    private final String lastSegmentTypeInfo;
    private final Map<EClass, SegmentIdeDescriptor> segmentToIdeDescriptorMap = new LinkedHashMap<EClass, SegmentIdeDescriptor>();
    private final List<ServiceReference<SegmentIdeDescriptor>> serviceReferences = new LinkedList<ServiceReference<SegmentIdeDescriptor>>();
    private AdvancedDMRWizardFirstPage firstPage;
    private VDomainModelReference advancedDmr;
    private final EClass lastSegmentType;
    private VDomainModelReference resultDmr;

    public CreateSegmentDmrWizard(EClass rootEClass, String windowTitle, VDomainModelReference existingDMR, EStructuralFeatureSelectionValidator selectionValidator, SegmentGenerator segmentGenerator, EClass lastSegmentType, boolean ignoreSegmentIdeRestriction) {
        this.setWindowTitle(windowTitle);
        this.rootEClass = rootEClass;
        this.existingDMR = existingDMR;
        this.selectionValidator = selectionValidator;
        this.segmentGenerator = segmentGenerator;
        this.lastSegmentType = lastSegmentType;
        this.setForcePreviousAndNextButtons(true);
        this.advancedDmr = VViewFactory.eINSTANCE.createDomainModelReference();
        this.lastSegmentTypeInfo = lastSegmentType != null ? "\nNote: Cannot finish because the last segment must be a " + lastSegmentType.getName() : "";
        try {
            BundleContext bundleContext = FrameworkUtil.getBundle(CreateSegmentDmrWizard.class).getBundleContext();
            Collection references = bundleContext.getServiceReferences(SegmentIdeDescriptor.class, null);
            for (ServiceReference serviceRef : references) {
                SegmentIdeDescriptor service = (SegmentIdeDescriptor)bundleContext.getService(serviceRef);
                if (!ignoreSegmentIdeRestriction && !service.isAvailableInIde()) continue;
                this.segmentToIdeDescriptorMap.put(service.getSegmentType(), service);
                this.serviceReferences.add((ServiceReference<SegmentIdeDescriptor>)serviceRef);
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    public Optional<VDomainModelReference> getDomainModelReference() {
        return Optional.ofNullable(this.resultDmr);
    }

    public void dispose() {
        BundleContext bundleContext = FrameworkUtil.getBundle(CreateSegmentDmrWizard.class).getBundleContext();
        for (ServiceReference<SegmentIdeDescriptor> serviceRef : this.serviceReferences) {
            bundleContext.ungetService(serviceRef);
        }
        this.segmentToIdeDescriptorMap.clear();
        this.serviceReferences.clear();
        super.dispose();
    }

    public void addPages() {
        this.firstPage = new AdvancedDMRWizardFirstPage("Configure Domain Model Reference", "Select an EStructuralFeature", "Select a structural feature for the domain model reference or switch to the advanced creation mode\n to create the reference path one feature at a time.", this.rootEClass, this.getInitialSelection());
        this.addPage((IWizardPage)this.firstPage);
    }

    private ISelection getInitialSelection() {
        if (this.existingDMR == null || this.existingDMR.getSegments().isEmpty()) {
            return TreeSelection.EMPTY;
        }
        List pathList = SegmentResolvementUtil.resolveSegmentsToFeatureList((List)this.existingDMR.getSegments(), (EClass)this.rootEClass);
        if (pathList.size() == this.existingDMR.getSegments().size()) {
            return new TreeSelection(new TreePath(pathList.toArray()));
        }
        return TreeSelection.EMPTY;
    }

    public boolean performFinish() {
        if (!this.canFinish()) {
            return false;
        }
        if (((Object)((Object)this.firstPage)).equals(this.getContainer().getCurrentPage())) {
            this.resultDmr = this.firstPage.getDomainModelReference();
        } else {
            SegmentCreationPage finalSegmentCreationPage = (SegmentCreationPage)this.getContainer().getCurrentPage();
            int lastSegmentIndex = finalSegmentCreationPage.index;
            int i = this.advancedDmr.getSegments().size() - 1;
            while (i > lastSegmentIndex) {
                this.advancedDmr.getSegments().remove(i);
                --i;
            }
            block1: for (VDomainModelReferenceSegment segment : this.advancedDmr.getSegments()) {
                for (Adapter adapter : segment.eAdapters()) {
                    if (!SegmentCreationPage.SegmentAdapter.class.isInstance(adapter)) continue;
                    segment.eAdapters().remove((Object)adapter);
                    continue block1;
                }
            }
            this.resultDmr = this.advancedDmr;
        }
        return true;
    }

    public boolean canFinish() {
        if (((Object)((Object)this.firstPage)).equals(this.getContainer().getCurrentPage())) {
            return this.firstPage.isPageComplete();
        }
        if (this.advancedDmr.getSegments().isEmpty() || !this.getContainer().getCurrentPage().isPageComplete()) {
            return false;
        }
        EList segments = this.advancedDmr.getSegments();
        VDomainModelReferenceSegment lastSegment = (VDomainModelReferenceSegment)segments.get(segments.size() - 1);
        SegmentIdeDescriptor descriptor = this.segmentToIdeDescriptorMap.get(lastSegment.eClass());
        if (!descriptor.isAllowedAsLastElementInPath()) {
            return false;
        }
        if (this.lastSegmentType == null) {
            return true;
        }
        return this.lastSegmentType.isInstance((Object)lastSegment);
    }

    private class AdvancedDMRWizardFirstPage
    extends SelectFeaturePathWizardPage {
        protected AdvancedDMRWizardFirstPage(String pageName, String pageTitle, String pageDescription, EClass rootEClass, ISelection firstSelection) {
            super(pageName, pageTitle, pageDescription, rootEClass, firstSelection, CreateSegmentDmrWizard.this.segmentGenerator, CreateSegmentDmrWizard.this.selectionValidator, false);
        }

        @Override
        public void createControl(Composite parent) {
            super.createControl(parent);
            Composite controlComposite = (Composite)this.getControl();
            Button advancedModeButton = new Button(controlComposite, 0);
            GridDataFactory.fillDefaults().align(4, 0x1000008).grab(true, false).applyTo((Control)advancedModeButton);
            advancedModeButton.setText("Switch To Advanced DMR Creation");
            if (!CreateSegmentDmrWizard.this.segmentToIdeDescriptorMap.isEmpty()) {
                advancedModeButton.setToolTipText("Using the advanced Domain Model Reference creation allows to use all available kinds of segments, i.e. index segments.");
                advancedModeButton.addListener(13, event -> {
                    SegmentCreationPage advancedPage = new SegmentCreationPage("Select Segment Type", CreateSegmentDmrWizard.this.rootEClass, 0);
                    CreateSegmentDmrWizard.this.addPage((IWizardPage)advancedPage);
                    CreateSegmentDmrWizard.this.advancedDmr = VViewFactory.eINSTANCE.createDomainModelReference();
                    this.getContainer().showPage((IWizardPage)advancedPage);
                });
            } else {
                advancedModeButton.setEnabled(false);
                advancedModeButton.setToolTipText("There are no segment types available for IDE usage. Therefore, the advanced creation mode is deactivated.");
            }
        }

        public boolean canFlipToNextPage() {
            return false;
        }
    }

    private class SegmentCreationPage
    extends WizardPage {
        private static final String PLEASE_SELECT_A_SEGMENT_TYPE_ERROR_MSG = "Please select a segment type.";
        private final int index;
        private Composite pageComposite;
        private ComposedAdapterFactory composedAdapterFactory;
        private AdapterFactoryLabelProvider labelProvider;
        private EClass rootEClass;
        private EClass segmentType;
        private VFeatureDomainModelReferenceSegment createdSegment;
        private Composite renderComposite;
        private SegmentCreationPage nextPage;
        private TableViewer tableViewer;
        private EStructuralFeature selectedFeature;
        private boolean pageCompleteWithoutValidation;

        protected SegmentCreationPage(String pageName, EClass rootEClass, int index) {
            super(pageName);
            this.setTitle("Create a Segment");
            this.setDescription("Create a segment by selecting its type and an appropriate feature.");
            this.rootEClass = rootEClass;
            this.index = index;
        }

        public boolean canFlipToNextPage() {
            EStructuralFeature feature;
            if (this.createdSegment == null) {
                return false;
            }
            SegmentIdeDescriptor ideDescriptor = (SegmentIdeDescriptor)CreateSegmentDmrWizard.this.segmentToIdeDescriptorMap.get(this.createdSegment.eClass());
            if (ideDescriptor.isLastElementInPath()) {
                return false;
            }
            String domainModelFeature = this.createdSegment.getDomainModelFeature();
            if (domainModelFeature != null && !domainModelFeature.isEmpty() && EReference.class.isInstance(feature = this.rootEClass.getEStructuralFeature(this.createdSegment.getDomainModelFeature()))) {
                if (VViewPackage.eINSTANCE.getFeatureDomainModelReferenceSegment().equals(this.createdSegment.eClass()) && ((EReference)EReference.class.cast(feature)).isMany()) {
                    return false;
                }
                if (this.nextPage.rootEClass != null) {
                    return super.canFlipToNextPage();
                }
            }
            return false;
        }

        public void setRootEClass(EClass rootEClass) {
            this.rootEClass = rootEClass;
            if (this.tableViewer != null) {
                this.tableViewer.setInput((Object)rootEClass);
            }
        }

        public void createControl(Composite parent) {
            int index;
            this.nextPage = new SegmentCreationPage(this.getName(), null, this.index + 1);
            CreateSegmentDmrWizard.this.addPage((IWizardPage)this.nextPage);
            this.pageComposite = new Composite(parent, 0);
            GridLayoutFactory.fillDefaults().applyTo(this.pageComposite);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.pageComposite);
            this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
            this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory);
            EStructuralFeatureContentProvider contentProvider = new EStructuralFeatureContentProvider(false);
            Set segmentClasses = CreateSegmentDmrWizard.this.segmentToIdeDescriptorMap.keySet();
            LinkedHashMap<String, EClass> segmentClassesMap = new LinkedHashMap<String, EClass>();
            for (EClass segmentClass : segmentClasses) {
                segmentClassesMap.put(segmentClass.getName(), segmentClass);
            }
            Composite segmentTypeComposite = new Composite(this.pageComposite, 0);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(segmentTypeComposite);
            GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)segmentTypeComposite);
            Label segmentSelectionLabel = new Label(segmentTypeComposite, 0);
            segmentSelectionLabel.setText("Select Segment Type:");
            GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)segmentSelectionLabel);
            Combo segmentTypeSelector = new Combo(segmentTypeComposite, 12);
            GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)segmentTypeSelector);
            Object[] items = segmentClassesMap.keySet().toArray(new String[segmentClassesMap.size()]);
            Arrays.sort(items);
            segmentTypeSelector.setItems((String[])items);
            this.tableViewer = new TableViewer(this.pageComposite);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo(this.tableViewer.getControl());
            this.tableViewer.setContentProvider((IContentProvider)contentProvider);
            this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            this.tableViewer.setInput((Object)this.rootEClass);
            this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)new FeatureSelectionChangedListerner());
            segmentTypeSelector.addListener(13, (Listener)new SegmentTypeSelectionListener(this.pageComposite, segmentClassesMap, this.tableViewer, segmentTypeSelector));
            if (segmentClassesMap.values().contains(VViewPackage.eINSTANCE.getFeatureDomainModelReferenceSegment()) && (index = Arrays.binarySearch(items, VViewPackage.eINSTANCE.getFeatureDomainModelReferenceSegment().getName())) >= 0) {
                segmentTypeSelector.select(index);
                segmentTypeSelector.notifyListeners(13, new Event());
            }
            this.setControl((Control)this.pageComposite);
        }

        private Composite initRenderComposite() {
            if (this.renderComposite != null) {
                this.renderComposite.dispose();
            }
            this.renderComposite = new Composite(this.pageComposite, 0);
            GridLayoutFactory.fillDefaults().applyTo(this.renderComposite);
            GridDataFactory.fillDefaults().align(4, 0x1000008).grab(true, false).applyTo((Control)this.renderComposite);
            return this.renderComposite;
        }

        private void initializeSegment() {
            if (this.segmentType == null) {
                return;
            }
            this.createdSegment = (VFeatureDomainModelReferenceSegment)EcoreUtil.create((EClass)this.segmentType);
            this.createdSegment.eAdapters().add((Object)new SegmentAdapter());
            if (CreateSegmentDmrWizard.this.advancedDmr.getSegments().size() > this.index) {
                CreateSegmentDmrWizard.this.advancedDmr.getSegments().set(this.index, (Object)this.createdSegment);
            } else {
                CreateSegmentDmrWizard.this.advancedDmr.getSegments().add((Object)this.createdSegment);
            }
            try {
                this.initRenderComposite();
                VView segmentView = ViewProviderHelper.getView((EObject)this.createdSegment, null);
                ViewModelContext context = ViewModelContextFactory.INSTANCE.createViewModelContext((VElement)segmentView, (EObject)this.createdSegment, new ViewModelService[]{new SelectedFeatureViewServiceImpl()});
                ECPSWTViewRenderer.INSTANCE.render(this.renderComposite, context);
                this.pageComposite.layout();
            }
            catch (ECPRendererException ex) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Rendering Error", (String)("The current segment could not be rendered: " + ex.getMessage()));
            }
        }

        private boolean validateSegment() {
            ValidationServiceImpl validator = new ValidationServiceImpl();
            Diagnostic diagnostic = validator.validate((EObject)this.createdSegment);
            if (diagnostic.getSeverity() == 1) {
                this.setMessage("Validation Information: " + diagnostic.getMessage());
            } else if (diagnostic.getSeverity() == 2) {
                this.setMessage("Validation Warning: " + diagnostic.getMessage());
            } else if (diagnostic.getSeverity() == 4) {
                this.setErrorMessage(diagnostic.getMessage());
                return false;
            }
            return true;
        }

        private class FeatureSelectionChangedListerner
        implements ISelectionChangedListener {
            private FeatureSelectionChangedListerner() {
            }

            public void selectionChanged(SelectionChangedEvent event) {
                int i = CreateSegmentDmrWizard.this.advancedDmr.getSegments().size() - 1;
                while (i > SegmentCreationPage.this.index) {
                    CreateSegmentDmrWizard.this.advancedDmr.getSegments().remove(i);
                    --i;
                }
                SegmentCreationPage.this.setPageComplete(false);
                SegmentCreationPage.this.pageCompleteWithoutValidation = false;
                IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
                if (structuredSelection.isEmpty()) {
                    return;
                }
                SegmentCreationPage.this.initializeSegment();
                EStructuralFeature structuralFeature = (EStructuralFeature)structuredSelection.getFirstElement();
                SegmentCreationPage.this.selectedFeature = structuralFeature;
                if (SegmentCreationPage.this.createdSegment == null) {
                    SegmentCreationPage.this.setErrorMessage(SegmentCreationPage.PLEASE_SELECT_A_SEGMENT_TYPE_ERROR_MSG);
                    return;
                }
                SegmentIdeDescriptor ideDescriptor = (SegmentIdeDescriptor)CreateSegmentDmrWizard.this.segmentToIdeDescriptorMap.get(SegmentCreationPage.this.createdSegment.eClass());
                String errorMessage = ideDescriptor.getEStructuralFeatureSelectionValidator().isValid(structuralFeature);
                SegmentCreationPage.this.setErrorMessage(errorMessage);
                if (errorMessage != null) {
                    return;
                }
                SegmentCreationPage.this.createdSegment.setDomainModelFeature(structuralFeature.getName());
                if (EReference.class.isInstance(structuralFeature)) {
                    EReference reference = (EReference)structuralFeature;
                    SegmentCreationPage.this.nextPage.setRootEClass(ideDescriptor.getReferenceTypeResolver().resolveNextEClass(reference, (VDomainModelReferenceSegment)SegmentCreationPage.this.createdSegment));
                    if (SegmentCreationPage.this.nextPage.rootEClass == null) {
                        return;
                    }
                }
                SegmentCreationPage.this.pageCompleteWithoutValidation = true;
                if (SegmentCreationPage.this.validateSegment()) {
                    SegmentCreationPage.this.setPageComplete(true);
                }
            }
        }

        private class SegmentAdapter
        extends AdapterImpl {
            private SegmentAdapter() {
            }

            public void notifyChanged(Notification notification) {
                if (notification.isTouch()) {
                    return;
                }
                if (SegmentCreationPage.this.validateSegment() && SegmentCreationPage.this.pageCompleteWithoutValidation) {
                    SegmentCreationPage.this.setErrorMessage(null);
                    SegmentCreationPage.this.setPageComplete(true);
                }
                if (EReference.class.isInstance(SegmentCreationPage.this.selectedFeature)) {
                    SegmentIdeDescriptor ideDescriptor = (SegmentIdeDescriptor)CreateSegmentDmrWizard.this.segmentToIdeDescriptorMap.get(SegmentCreationPage.this.createdSegment.eClass());
                    SegmentCreationPage.this.nextPage.setRootEClass(ideDescriptor.getReferenceTypeResolver().resolveNextEClass((EReference)EReference.class.cast(SegmentCreationPage.this.selectedFeature), (VDomainModelReferenceSegment)SegmentCreationPage.this.createdSegment));
                }
            }
        }

        private final class SegmentTypeSelectionListener
        implements Listener {
            private final Map<String, EClass> segmentClassesMap;
            private final TableViewer tableViewer;
            private final Combo segmentTypeSelector;

            private SegmentTypeSelectionListener(Composite composite, Map<String, EClass> segmentClassesMap, TableViewer tableViewer, Combo segmentTypeSelector) {
                this.segmentClassesMap = segmentClassesMap;
                this.tableViewer = tableViewer;
                this.segmentTypeSelector = segmentTypeSelector;
            }

            public void handleEvent(Event event) {
                if (this.segmentTypeSelector.getText() == null || this.segmentTypeSelector.getText().isEmpty()) {
                    SegmentCreationPage.this.setErrorMessage(SegmentCreationPage.PLEASE_SELECT_A_SEGMENT_TYPE_ERROR_MSG);
                    SegmentCreationPage.this.createdSegment = null;
                }
                if (SegmentCreationPage.PLEASE_SELECT_A_SEGMENT_TYPE_ERROR_MSG.equals(SegmentCreationPage.this.getErrorMessage())) {
                    SegmentCreationPage.this.setErrorMessage(null);
                }
                SegmentCreationPage.this.segmentType = this.segmentClassesMap.get(this.segmentTypeSelector.getText());
                if (CreateSegmentDmrWizard.this.lastSegmentType != null && !CreateSegmentDmrWizard.this.lastSegmentType.isSuperTypeOf(SegmentCreationPage.this.segmentType) && !SegmentCreationPage.this.getDescription().endsWith(CreateSegmentDmrWizard.this.lastSegmentTypeInfo)) {
                    SegmentCreationPage.this.setDescription(String.valueOf(SegmentCreationPage.this.getDescription()) + CreateSegmentDmrWizard.this.lastSegmentTypeInfo);
                } else if (CreateSegmentDmrWizard.this.lastSegmentType != null && CreateSegmentDmrWizard.this.lastSegmentType.isSuperTypeOf(SegmentCreationPage.this.segmentType) && SegmentCreationPage.this.getDescription().endsWith(CreateSegmentDmrWizard.this.lastSegmentTypeInfo)) {
                    String desc = SegmentCreationPage.this.getDescription();
                    SegmentCreationPage.this.setDescription(desc.substring(0, desc.length() - CreateSegmentDmrWizard.this.lastSegmentTypeInfo.length()));
                }
                SegmentCreationPage.this.initializeSegment();
                this.tableViewer.setSelection(this.tableViewer.getSelection(), true);
            }
        }

        private class SelectedFeatureViewServiceImpl
        implements SelectedFeatureViewService {
            private SelectedFeatureViewServiceImpl() {
            }

            public void instantiate(ViewModelContext context) {
            }

            public void dispose() {
            }

            public int getPriority() {
                return 0;
            }

            @Override
            public EStructuralFeature getFeature() {
                return SegmentCreationPage.this.selectedFeature;
            }
        }
    }
}

