/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ide.spi.util;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;

public final class WorkspaceUtil {
    private WorkspaceUtil() {
    }

    public static List<URI> getURIsInWorkspace(final String fileExtension) throws CoreException {
        final ArrayList<URI> uris = new ArrayList<URI>();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.getRoot().accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource.getFileExtension() != null && resource.getFileExtension().equals(fileExtension)) {
                    try {
                        uris.add(URI.createURI((String)resource.getLocationURI().toURL().toExternalForm()));
                    }
                    catch (MalformedURLException ex) {
                        return false;
                    }
                }
                return resource.getType() != 1;
            }
        });
        return uris;
    }

    public static File uriToFile(URI uri) {
        if (uri.isFile() && !uri.isRelative()) {
            return new Path(uri.toFileString()).toFile();
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.path())).getLocation().toFile();
    }
}

