/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.segments;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeAddRemoveListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeListener;
import org.eclipse.emf.ecp.view.spi.model.ModelChangeNotification;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.core.services.segments.EMFFormsSegmentGenerator;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewContext;

public class DmrToSegmentsViewService
implements ModelChangeAddRemoveListener {
    private final EMFFormsSegmentGenerator segmentGenerator;

    public DmrToSegmentsViewService(EMFFormsViewContext viewContext) {
        viewContext.registerViewChangeListener((ModelChangeListener)this);
        this.segmentGenerator = (EMFFormsSegmentGenerator)viewContext.getService(EMFFormsSegmentGenerator.class);
        VElement view = viewContext.getViewModel();
        LinkedList allDmrs = new LinkedList();
        view.eAllContents().forEachRemaining(object -> {
            if (object instanceof VDomainModelReference) {
                allDmrs.add((VDomainModelReference)object);
            }
        });
        allDmrs.forEach(this::addSegmentsIfNecessary);
    }

    private void addSegmentsIfNecessary(VDomainModelReference dmr) {
        if (!dmr.getSegments().isEmpty()) {
            return;
        }
        List<VDomainModelReferenceSegment> segments = this.segmentGenerator.generateSegments(dmr);
        dmr.getSegments().addAll(segments);
    }

    public void notifyChange(ModelChangeNotification notification) {
    }

    public void notifyAdd(Notifier notifier) {
        if (notifier instanceof VDomainModelReference) {
            this.addSegmentsIfNecessary((VDomainModelReference)notifier);
        }
    }

    public void notifyRemove(Notifier notifier) {
    }
}

