/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.validation;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ValidationContentProvider
implements ITreeContentProvider {
    private final Map<Object, Object> diagnosticToParentMap = new LinkedHashMap<Object, Object>();

    public void dispose() {
        this.diagnosticToParentMap.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.diagnosticToParentMap.clear();
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Diagnostic) {
            return this.getChildren(inputElement);
        }
        if (inputElement instanceof Diagnostic[]) {
            return (Diagnostic[])inputElement;
        }
        if (inputElement instanceof List) {
            return ((List)inputElement).toArray(new Diagnostic[((List)inputElement).size()]);
        }
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        Object[] childDiagnostics;
        Diagnostic diagnostic = (Diagnostic)parentElement;
        Object[] objectArray = childDiagnostics = diagnostic.getChildren().toArray(new Diagnostic[diagnostic.getChildren().size()]);
        int n = childDiagnostics.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            this.diagnosticToParentMap.put(child, diagnostic);
            ++n2;
        }
        return childDiagnostics;
    }

    public Object getParent(Object element) {
        return this.diagnosticToParentMap.get(element);
    }

    public boolean hasChildren(Object element) {
        Diagnostic diagnostic = (Diagnostic)element;
        return diagnostic.getChildren().size() > 0;
    }
}

