/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.swt.action;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.spi.table.swt.action.TableRendererAction;
import org.eclipse.emf.ecp.view.spi.table.swt.action.TableRendererViewerActionContext;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class DuplicateRowAction
extends TableRendererAction {
    public static final String ACTION_ID = "org.eclipse.emfforms.action.tablecontrol.duplicate_row";
    public static final String DEFAULT_KEYBINDING = "M1+d";

    public DuplicateRowAction(TableRendererViewerActionContext actionContext) {
        super(actionContext);
    }

    public String getId() {
        return ACTION_ID;
    }

    public void execute() {
        EStructuralFeature.Setting setting = this.getActionContext().getSetting();
        EObject eObject = setting.getEObject();
        EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
        List<Object> toDuplicate = Arrays.asList(((IStructuredSelection)this.getTableViewer().getSelection()).toArray());
        Collection<Object> copies = this.copyElements(eObject, eStructuralFeature, this.getEditingDomainForContainment(), toDuplicate);
        this.getTableViewer().setSelection((ISelection)new StructuredSelection(copies.iterator().next()), true);
    }

    private Collection<Object> copyElements(EObject eObject, EStructuralFeature structuralFeature, EditingDomain editingDomain, Collection<?> elementsToCopy) {
        Collection copies = EcoreUtil.copyAll(elementsToCopy);
        Command createCommand = AddCommand.create((EditingDomain)editingDomain, (Object)eObject, (Object)structuralFeature, (Collection)copies);
        if (createCommand.canExecute()) {
            if (editingDomain.getCommandStack() == null) {
                createCommand.execute();
            } else {
                editingDomain.getCommandStack().execute(createCommand);
            }
        }
        return copies;
    }

    public boolean canExecute() {
        return !this.isTableDisabled() && !this.isUpperBoundReached() && !this.isViewerSelectionInvalid();
    }
}

