/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emf2web.ui.handler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecp.emf2web.controller.GenerationController;
import org.eclipse.emf.ecp.emf2web.exporter.GenerationExporter;
import org.eclipse.emf.ecp.emf2web.ui.messages.Messages;
import org.eclipse.emf.ecp.emf2web.ui.wizard.ExportSchemasWizard;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractSchemaExportCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Collection<VView> views;
        block3: {
            views = this.getViews(event);
            if (views != null && !views.isEmpty()) break block3;
            return null;
        }
        try {
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            this.openWizard(views, event, shell);
        }
        catch (RuntimeException e) {
            this.handleRuntimeException(e);
        }
        return null;
    }

    protected void handleRuntimeException(RuntimeException e) throws ExecutionException {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String stackTrace = sw.toString();
        ArrayList<Status> childStatuses = new ArrayList<Status>();
        String[] stringArray = stackTrace.split(System.getProperty("line.separator"));
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            childStatuses.add(new Status(4, "org.eclipse.emf.ecp.emf2web.ui", line));
            ++n2;
        }
        MultiStatus status = new MultiStatus("org.eclipse.emf.ecp.emf2web.ui", 4, (IStatus[])childStatuses.toArray(new Status[0]), e.getLocalizedMessage(), (Throwable)e);
        ErrorDialog.openError(null, (String)Messages.getString("AbstractSchemaExportCommandHandler.Error_Title"), (String)Messages.getString("AbstractSchemaExportCommandHandler.Error_Message"), (IStatus)status);
        throw new ExecutionException(Messages.getString("AbstractSchemaExportCommandHandler.Error_Message"), (Throwable)e);
    }

    protected int openWizard(Collection<VView> views, ExecutionEvent event, Shell shell) {
        List generationInfos = this.getGenerationController().generate(views);
        URI locationProposal = this.getLocationProposal(event);
        ExportSchemasWizard wizard = new ExportSchemasWizard(generationInfos, this.getGenerationExporter(), locationProposal);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.setPageSize(new Point(600, 600));
        return dialog.open();
    }

    protected URI getLocationProposal(ExecutionEvent event) {
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Object firstElement = selection.getFirstElement();
        if (IFile.class.isInstance(firstElement)) {
            IFile file = (IFile)IFile.class.cast(firstElement);
            IContainer container = file.getParent();
            return URI.createPlatformResourceURI((String)container.getFullPath().toString(), (boolean)true);
        }
        return null;
    }

    protected abstract Collection<VView> getViews(ExecutionEvent var1);

    protected abstract GenerationController getGenerationController();

    protected abstract GenerationExporter getGenerationExporter();
}

