/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.changebroker.internal;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.changebroker.internal.ContainingEClassStrategy;
import org.eclipse.emf.ecp.changebroker.internal.EClassStrategy;
import org.eclipse.emf.ecp.changebroker.internal.FeatureStrategy;
import org.eclipse.emf.ecp.changebroker.internal.NoStrategy;
import org.eclipse.emf.ecp.changebroker.internal.Strategy;
import org.eclipse.emf.ecp.changebroker.spi.ChangeBroker;
import org.eclipse.emf.ecp.changebroker.spi.ChangeObserver;
import org.eclipse.emf.ecp.changebroker.spi.EMFObserver;
import org.eclipse.emf.ecp.changebroker.spi.NotificationProvider;
import org.eclipse.emf.ecp.changebroker.spi.NotificationReceiver;
import org.eclipse.emf.ecp.changebroker.spi.PostDeleteObserver;
import org.eclipse.emf.ecp.changebroker.spi.PreDeleteObserver;
import org.eclipse.emf.ecp.changebroker.spi.ReadOnlyChangeObserver;
import org.eclipse.emf.ecp.changebroker.spi.VetoableDeleteObserver;

public class ChangeBrokerImpl
implements ChangeBroker,
NotificationReceiver {
    private final Set<NotificationProvider> providers = new CopyOnWriteArraySet<NotificationProvider>();
    private boolean stopNotifyingEMFObservers;
    private final Set<Object> blocker = new CopyOnWriteArraySet<Object>();
    private final Set<Notification> runningNotifications = new LinkedHashSet<Notification>();
    private final NoStrategy noStrategy = new NoStrategy();
    private final EClassStrategy eClassStrategy = new EClassStrategy();
    private final ContainingEClassStrategy containingEClassStrategy = new ContainingEClassStrategy();
    private final FeatureStrategy featureStrategy = new FeatureStrategy();
    private final Strategy[] strategies;
    private final NoStrategy readOnlyNoStrategy = new NoStrategy();
    private final EClassStrategy readOnlyEClassStrategy = new EClassStrategy();
    private final ContainingEClassStrategy readOnlyContainingEClassStrategy = new ContainingEClassStrategy();
    private final FeatureStrategy readOnlyFeatureStrategy = new FeatureStrategy();
    private final Strategy[] readOnlyStrategies;
    private final Set<PreDeleteObserver> preDeleteObserver = new CopyOnWriteArraySet<PreDeleteObserver>();
    private final Set<PostDeleteObserver> postDeleteObserver = new CopyOnWriteArraySet<PostDeleteObserver>();
    private final Set<VetoableDeleteObserver> vetoableDeleteObserver = new CopyOnWriteArraySet<VetoableDeleteObserver>();

    public ChangeBrokerImpl() {
        this.strategies = new Strategy[]{this.noStrategy, this.eClassStrategy, this.containingEClassStrategy, this.featureStrategy};
        this.readOnlyStrategies = new Strategy[]{this.readOnlyNoStrategy, this.readOnlyEClassStrategy, this.readOnlyContainingEClassStrategy, this.readOnlyFeatureStrategy};
    }

    public void addNotificationProvider(NotificationProvider provider) {
        if (this.providers.add(provider)) {
            provider.addReceiver(this);
        }
    }

    public void removeNotificationProvider(NotificationProvider provider) {
        if (this.providers.remove(provider)) {
            provider.removeReceiver(this);
        }
    }

    @Override
    public void notify(Notification notification) {
        Strategy strategy;
        boolean includeEMFObservers = this.startNotify(notification);
        LinkedHashSet<ChangeObserver> observers = new LinkedHashSet<ChangeObserver>();
        Strategy[] strategyArray = this.readOnlyStrategies;
        int n = this.readOnlyStrategies.length;
        int n2 = 0;
        while (n2 < n) {
            strategy = strategyArray[n2];
            observers.addAll(strategy.getObservers(notification));
            ++n2;
        }
        if (includeEMFObservers) {
            strategyArray = this.strategies;
            n = this.strategies.length;
            n2 = 0;
            while (n2 < n) {
                strategy = strategyArray[n2];
                observers.addAll(strategy.getObservers(notification));
                ++n2;
            }
        }
        for (ChangeObserver observer : observers) {
            observer.handleNotification(notification);
        }
        this.endNotify(notification);
    }

    private synchronized boolean startNotify(Notification notification) {
        boolean includeEMFObservers = !this.stopNotifyingEMFObservers && this.runningNotifications.isEmpty() && this.blocker.isEmpty();
        this.runningNotifications.add(notification);
        return includeEMFObservers;
    }

    private synchronized void endNotify(Notification notification) {
        this.runningNotifications.remove(notification);
    }

    @Override
    public void subscribe(EMFObserver observer) {
        if (ReadOnlyChangeObserver.class.isInstance(observer)) {
            this.readOnlyNoStrategy.register((ChangeObserver)observer);
        } else if (ChangeObserver.class.isInstance(observer)) {
            this.noStrategy.register((ChangeObserver)observer);
        }
        if (PreDeleteObserver.class.isInstance(observer)) {
            this.preDeleteObserver.add((PreDeleteObserver)observer);
        }
        if (PostDeleteObserver.class.isInstance(observer)) {
            this.postDeleteObserver.add((PostDeleteObserver)observer);
        }
        if (VetoableDeleteObserver.class.isInstance(observer)) {
            this.vetoableDeleteObserver.add((VetoableDeleteObserver)observer);
        }
    }

    @Override
    public void subscribeToEClass(ChangeObserver observer, EClass eClass) {
        if (ReadOnlyChangeObserver.class.isInstance(observer)) {
            this.readOnlyEClassStrategy.register(observer, eClass);
        } else {
            this.eClassStrategy.register(observer, eClass);
        }
    }

    @Override
    public void subscribeToTree(ChangeObserver observer, EClass eClass) {
        if (ReadOnlyChangeObserver.class.isInstance(observer)) {
            this.readOnlyContainingEClassStrategy.register(observer, eClass);
        } else {
            this.containingEClassStrategy.register(observer, eClass);
        }
    }

    @Override
    public void subscribeToFeature(ChangeObserver observer, EStructuralFeature feature) {
        if (ReadOnlyChangeObserver.class.isInstance(observer)) {
            this.readOnlyFeatureStrategy.register(observer, feature);
        } else {
            this.featureStrategy.register(observer, feature);
        }
    }

    @Override
    public void unsubsribe(EMFObserver receiver) {
        if (ChangeObserver.class.isInstance(receiver)) {
            Strategy[] strategyArray = this.strategies;
            int n = this.strategies.length;
            int n2 = 0;
            while (n2 < n) {
                Strategy strategy = strategyArray[n2];
                strategy.deregister((ChangeObserver)receiver);
                ++n2;
            }
        }
        if (PreDeleteObserver.class.isInstance(receiver)) {
            this.preDeleteObserver.remove(receiver);
        }
        if (PostDeleteObserver.class.isInstance(receiver)) {
            this.postDeleteObserver.remove(receiver);
        }
        if (VetoableDeleteObserver.class.isInstance(receiver)) {
            this.vetoableDeleteObserver.remove(receiver);
        }
    }

    @Override
    public void stopNotification() {
        this.stopNotifyingEMFObservers = true;
    }

    @Override
    public void continueNotification() {
        this.stopNotifyingEMFObservers = false;
    }

    public Set<NotificationProvider> getNotificationProviders() {
        return new LinkedHashSet<NotificationProvider>(this.providers);
    }

    public Set<ChangeObserver> getRegisteredObservers() {
        Strategy strategy;
        LinkedHashSet<ChangeObserver> hashSet = new LinkedHashSet<ChangeObserver>();
        Strategy[] strategyArray = this.strategies;
        int n = this.strategies.length;
        int n2 = 0;
        while (n2 < n) {
            strategy = strategyArray[n2];
            hashSet.addAll(strategy.getAllObservers());
            ++n2;
        }
        strategyArray = this.readOnlyStrategies;
        n = this.readOnlyStrategies.length;
        n2 = 0;
        while (n2 < n) {
            strategy = strategyArray[n2];
            hashSet.addAll(strategy.getAllObservers());
            ++n2;
        }
        return hashSet;
    }

    @Override
    public void stopNotification(Object blocker) {
        this.blocker.add(blocker);
    }

    @Override
    public void continueNotification(Object blocker) {
        this.blocker.remove(blocker);
        this.continueNotification();
    }

    @Override
    public void notifyPreDelete(EObject toBeDeleted) {
        for (PreDeleteObserver observer : this.preDeleteObserver) {
            observer.preDelete(toBeDeleted);
        }
    }

    @Override
    public void notifyPostDelete(EObject toBeDeleted) {
        for (PostDeleteObserver observer : this.postDeleteObserver) {
            observer.postDelete(toBeDeleted);
        }
    }

    @Override
    public boolean canDelete(EObject toBeDeleted) {
        boolean canDelete = true;
        for (VetoableDeleteObserver observer : this.vetoableDeleteObserver) {
            canDelete = observer.canDelete(toBeDeleted);
            if (!canDelete) break;
        }
        return canDelete;
    }
}

