/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.table.nebula.grid;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.table.swt.TableConfigurationHelper;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emfforms.spi.common.converter.EStructuralFeatureValueConverterService;
import org.eclipse.emfforms.spi.core.services.databinding.emf.EMFFormsDatabindingEMF;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class GridPasteKeyListener
implements KeyListener {
    private final Clipboard clipboard;
    private final EMFFormsDatabindingEMF dataBinding;
    private final EStructuralFeatureValueConverterService converterService;
    private final VControl vControl;
    private boolean selectPastedCells = true;
    private boolean alreadyPasted;

    public GridPasteKeyListener(Display display, VControl vControl, EMFFormsDatabindingEMF dataBinding, EStructuralFeatureValueConverterService converterService, boolean selectPastedCells) {
        this.clipboard = new Clipboard(display);
        this.vControl = vControl;
        this.dataBinding = dataBinding;
        this.converterService = converterService;
        this.selectPastedCells = selectPastedCells;
    }

    public void keyPressed(KeyEvent e) {
        if ((e.stateMask & 0x40000) != 0 && e.keyCode == 118) {
            if (!this.alreadyPasted) {
                Grid grid = (Grid)e.widget;
                Object contents = this.clipboard.getContents((Transfer)TextTransfer.getInstance());
                if (contents instanceof String) {
                    this.pasteSelection(grid, (String)contents);
                }
                this.alreadyPasted = true;
            }
        } else {
            this.alreadyPasted = false;
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void pasteSelection(Grid grid, String contents) {
        if (grid.getCellSelection().length == 0 || !this.vControl.isEnabled() || this.vControl.isReadonly()) {
            return;
        }
        ArrayList<Point> pastedCells = new ArrayList<Point>();
        if (grid.getCellSelection().length > 1 && new StringTokenizer(contents, "\n\t", false).countTokens() == 1) {
            Point[] pointArray = grid.getCellSelection();
            int n = pointArray.length;
            int n2 = 0;
            while (n2 < n) {
                Point startItem = pointArray[n2];
                pastedCells.addAll(this.pasteContents(startItem, grid, contents));
                ++n2;
            }
        } else {
            Point startItem = grid.getCellSelection()[0];
            pastedCells.addAll(this.pasteContents(startItem, grid, contents));
        }
        if (this.selectPastedCells && !pastedCells.isEmpty() && grid.isCellSelectionEnabled()) {
            grid.setCellSelection(pastedCells.toArray(new Point[0]));
        }
    }

    public List<Point> pasteContents(Point startItem, Grid grid, String contents) {
        String[] rows;
        int startColumn = startItem.x;
        int startRow = startItem.y;
        ArrayList<Point> pastedCells = new ArrayList<Point>();
        ArrayList<IObservableValue> pastedValues = new ArrayList<IObservableValue>();
        int relativeRow = 0;
        String[] stringArray = rows = contents.split("\r\n|\n", -1);
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            String row = stringArray[n2];
            int relativeColumn = 0;
            String[] stringArray2 = row.split("\t", -1);
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String cellValue = stringArray2[n4];
                int insertionColumnIndex = startColumn + relativeColumn;
                int insertionRowIndex = startRow + relativeRow;
                if (insertionColumnIndex >= grid.getColumnCount()) {
                    ++relativeColumn;
                } else {
                    VDomainModelReference dmr = (VDomainModelReference)grid.getColumn(insertionColumnIndex).getData("domain_model_reference");
                    if (dmr == null || this.vControl instanceof VTableControl && TableConfigurationHelper.isReadOnly((VTableControl)((VTableControl)this.vControl), (VDomainModelReference)dmr)) {
                        ++relativeColumn;
                    } else {
                        block16: {
                            if (insertionRowIndex < grid.getItemCount()) {
                                EObject eObject = (EObject)grid.getItem(insertionRowIndex).getData();
                                IObservableValue value = null;
                                try {
                                    try {
                                        value = this.dataBinding.getObservableValue(dmr, eObject);
                                        Object convertedValue = this.converterService.convertToModelValue(eObject, (EStructuralFeature)value.getValueType(), cellValue);
                                        if (convertedValue != null) {
                                            value.setValue(convertedValue);
                                            pastedValues.add(value);
                                        }
                                        pastedCells.add(new Point(insertionColumnIndex, insertionRowIndex));
                                    }
                                    catch (Exception exception) {
                                        if (value != null) {
                                            value.dispose();
                                        }
                                        break block16;
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (value != null) {
                                        value.dispose();
                                    }
                                    throw throwable;
                                }
                                if (value != null) {
                                    value.dispose();
                                }
                            }
                        }
                        ++relativeColumn;
                    }
                }
                ++n4;
            }
            ++relativeRow;
            ++n2;
        }
        return pastedCells;
    }
}

