/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.editor.controls.Activator;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SelectAttributesWizardPage
extends WizardPage {
    private EClass rootClass;
    private AdapterFactoryLabelProvider labelProvider;
    private ComposedAdapterFactory composedAdapterFactory;
    private final Set<EStructuralFeature> selectedFeatures = new LinkedHashSet<EStructuralFeature>();
    private VView view;
    private Composite parent;
    private Composite composite;
    private CheckboxTableViewer tvAttributes;
    private Button bUnreferenced;

    protected SelectAttributesWizardPage() {
        super("Select Attributes");
    }

    public void createControl(Composite parent) {
        this.parent = parent;
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.composite.setLayout((Layout)layout);
        this.setControl((Control)this.composite);
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory);
        this.bUnreferenced = new Button(this.composite, 32);
        this.bUnreferenced.setText("Show only unreferenced Attributes?");
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).span(2, 1).applyTo((Control)this.bUnreferenced);
        ScrolledComposite scrolledComposite = new ScrolledComposite(this.composite, 2816);
        scrolledComposite.setShowFocusedControl(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)scrolledComposite);
        GridLayoutFactory.fillDefaults().applyTo((Composite)scrolledComposite);
        Composite tableComposite = new Composite((Composite)scrolledComposite, 4);
        tableComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)tableComposite);
        tableComposite.setBackground(scrolledComposite.getBackground());
        this.tvAttributes = CheckboxTableViewer.newCheckList((Composite)tableComposite, (int)0);
        this.tvAttributes.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tvAttributes.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(-1, 200).applyTo(this.tvAttributes.getControl());
        scrolledComposite.setContent((Control)tableComposite);
        Point point = tableComposite.computeSize(-1, -1);
        scrolledComposite.setMinSize(point);
        this.tvAttributes.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                EStructuralFeature object = (EStructuralFeature)event.getElement();
                if (event.getChecked()) {
                    SelectAttributesWizardPage.this.selectedFeatures.add(object);
                } else {
                    SelectAttributesWizardPage.this.selectedFeatures.remove(object);
                }
                SelectAttributesWizardPage.this.setPageComplete(!SelectAttributesWizardPage.this.selectedFeatures.isEmpty());
            }
        });
        Object attributes = null;
        if (this.rootClass != null) {
            attributes = !this.bUnreferenced.getSelection() ? this.rootClass.getEAllStructuralFeatures() : this.getUnreferencedSegmentAttributes(this.rootClass);
        }
        this.tvAttributes.setInput(attributes);
        this.bUnreferenced.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object attributes = null;
                if (SelectAttributesWizardPage.this.rootClass != null) {
                    attributes = !SelectAttributesWizardPage.this.bUnreferenced.getSelection() ? SelectAttributesWizardPage.this.rootClass.getEAllStructuralFeatures() : SelectAttributesWizardPage.this.getUnreferencedSegmentAttributes(SelectAttributesWizardPage.this.rootClass);
                }
                SelectAttributesWizardPage.this.tvAttributes.setInput(attributes);
            }
        });
        Composite compositeButtons = new Composite(this.composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(compositeButtons);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).span(2, 1).applyTo((Control)compositeButtons);
        Button bSelectAll = new Button(compositeButtons, 8);
        bSelectAll.setText("Select All");
        bSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List segments = (List)SelectAttributesWizardPage.this.tvAttributes.getInput();
                SelectAttributesWizardPage.this.tvAttributes.setAllChecked(true);
                SelectAttributesWizardPage.this.selectedFeatures.addAll(segments);
                SelectAttributesWizardPage.this.setPageComplete(!SelectAttributesWizardPage.this.selectedFeatures.isEmpty());
            }
        });
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)bSelectAll);
        Button bDeSelectAll = new Button(compositeButtons, 8);
        bDeSelectAll.setText("Deselect All");
        bDeSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List segments = (List)SelectAttributesWizardPage.this.tvAttributes.getInput();
                SelectAttributesWizardPage.this.tvAttributes.setAllChecked(false);
                SelectAttributesWizardPage.this.selectedFeatures.removeAll(segments);
                SelectAttributesWizardPage.this.setPageComplete(!SelectAttributesWizardPage.this.selectedFeatures.isEmpty());
            }
        });
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)bDeSelectAll);
        parent.layout(true);
        scrolledComposite.layout(true);
    }

    public void onEnterPage() {
        this.clear();
        this.composite = new Composite(this.parent, 0);
        GridLayout layout = new GridLayout();
        this.composite.setLayout((Layout)layout);
        layout.numColumns = 2;
        this.setControl((Control)this.composite);
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)this.composedAdapterFactory);
        final Button bUnreferenced = new Button(this.composite, 32);
        bUnreferenced.setText("Show only unreferenced Attributes?");
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).span(2, 1).applyTo((Control)bUnreferenced);
        Label labelAttributes = new Label(this.composite, 0);
        labelAttributes.setText("Select Attributes");
        ScrolledComposite scrolledComposite = new ScrolledComposite(this.composite, 2816);
        scrolledComposite.setShowFocusedControl(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)scrolledComposite);
        GridLayoutFactory.fillDefaults().applyTo((Composite)scrolledComposite);
        Composite tableComposite = new Composite((Composite)scrolledComposite, 4);
        tableComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)tableComposite);
        tableComposite.setBackground(scrolledComposite.getBackground());
        final CheckboxTableViewer tvAttributes = CheckboxTableViewer.newCheckList((Composite)tableComposite, (int)0);
        tvAttributes.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        tvAttributes.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(-1, 200).applyTo(tvAttributes.getControl());
        scrolledComposite.setContent((Control)tableComposite);
        Point point = tableComposite.computeSize(-1, -1);
        scrolledComposite.setMinSize(point);
        tvAttributes.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                EStructuralFeature object = (EStructuralFeature)event.getElement();
                if (event.getChecked()) {
                    SelectAttributesWizardPage.this.selectedFeatures.add(object);
                } else {
                    SelectAttributesWizardPage.this.selectedFeatures.remove(object);
                }
                SelectAttributesWizardPage.this.setPageComplete(!SelectAttributesWizardPage.this.selectedFeatures.isEmpty());
            }
        });
        Object attributes = null;
        attributes = !bUnreferenced.getSelection() ? this.rootClass.getEAllStructuralFeatures() : this.getUnreferencedSegmentAttributes(this.rootClass);
        tvAttributes.setInput(attributes);
        bUnreferenced.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object attributes = null;
                attributes = !bUnreferenced.getSelection() ? SelectAttributesWizardPage.this.rootClass.getEAllStructuralFeatures() : SelectAttributesWizardPage.this.getUnreferencedSegmentAttributes(SelectAttributesWizardPage.this.rootClass);
                tvAttributes.setInput(attributes);
            }
        });
        Composite compositeButtons = new Composite(this.composite, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(compositeButtons);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).span(2, 1).applyTo((Control)compositeButtons);
        Button bSelectAll = new Button(compositeButtons, 8);
        bSelectAll.setText("Select All");
        bSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List segments = (List)tvAttributes.getInput();
                tvAttributes.setAllChecked(true);
                SelectAttributesWizardPage.this.selectedFeatures.addAll(segments);
                SelectAttributesWizardPage.this.setPageComplete(!SelectAttributesWizardPage.this.selectedFeatures.isEmpty());
            }
        });
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)bSelectAll);
        Button bDeSelectAll = new Button(compositeButtons, 8);
        bDeSelectAll.setText("Deselect All");
        bDeSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                List segments = (List)tvAttributes.getInput();
                tvAttributes.setAllChecked(false);
                SelectAttributesWizardPage.this.selectedFeatures.removeAll(segments);
                SelectAttributesWizardPage.this.setPageComplete(!SelectAttributesWizardPage.this.selectedFeatures.isEmpty());
            }
        });
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)bDeSelectAll);
        this.parent.layout(true);
        scrolledComposite.layout(true);
    }

    public boolean isPageComplete() {
        return super.isPageComplete();
    }

    private void clear() {
        if (this.parent != null && !this.parent.isDisposed()) {
            Control[] controlArray = this.parent.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
        }
    }

    public void setRootClass(EClass eClass) {
        this.rootClass = eClass;
        this.selectedFeatures.clear();
        if (this.tvAttributes != null) {
            EList attributes = null;
            attributes = this.rootClass.getEAllStructuralFeatures();
            this.tvAttributes.setInput((Object)attributes);
        }
    }

    private List<EStructuralFeature> getUnreferencedSegmentAttributes(EClass eClass) {
        ArrayList<EStructuralFeature> result = new ArrayList<EStructuralFeature>();
        ArrayList<EStructuralFeature> allStructuralFeatures = new ArrayList<EStructuralFeature>((Collection<EStructuralFeature>)eClass.getEAllStructuralFeatures());
        TreeIterator eAllContents = this.view.eAllContents();
        while (eAllContents.hasNext()) {
            IValueProperty valueProperty;
            VControl control;
            VDomainModelReference domainModelReference;
            EObject eObject = (EObject)eAllContents.next();
            if (!VControl.class.isInstance(eObject) || (domainModelReference = (control = (VControl)eObject).getDomainModelReference()) == null) continue;
            try {
                valueProperty = Activator.getDefault().getEMFFormsDatabinding().getValueProperty(domainModelReference, null);
            }
            catch (DatabindingFailedException ex) {
                Activator.getDefault().getReportService().report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
                continue;
            }
            EStructuralFeature feature = (EStructuralFeature)valueProperty.getValueType();
            if (feature == null || feature.getEContainingClass() == null || !feature.getEContainingClass().equals(eClass)) continue;
            result.add(feature);
        }
        allStructuralFeatures.removeAll(result);
        return allStructuralFeatures;
    }

    public Set<EStructuralFeature> getSelectedFeatures() {
        return this.selectedFeatures;
    }

    public IWizardPage getPreviousPage() {
        return super.getPreviousPage();
    }

    public void setView(VView view) {
        this.view = view;
    }

    public boolean isCurrentPage() {
        return super.isCurrentPage();
    }

    public void clearSelection() {
        this.getSelectedFeatures().clear();
        this.tvAttributes.setAllChecked(false);
    }
}

