/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.ide.view.mappingsegment;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.spi.EMFUtils;
import org.eclipse.emf.ecp.view.internal.editor.controls.EditableEReferenceLabelControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.editor.controls.SelectedFeatureViewService;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.view.mappingsegment.model.VMappingDomainModelReferenceSegment;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class MappedEClassControlSWTRenderer
extends EditableEReferenceLabelControlSWTRenderer {
    @Inject
    public MappedEClassControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService) {
        super(vElement, viewContext, reportService);
    }

    protected void linkValue(Shell shell) {
        Object selection2;
        IObservableValue observableValue;
        try {
            observableValue = this.getEMFFormsDatabinding().getObservableValue(((VControl)this.getVElement()).getDomainModelReference(), this.getViewModelContext().getDomainModel());
        }
        catch (DatabindingFailedException ex) {
            this.showLinkValueFailedMessageDialog(shell, (Exception)((Object)ex));
            return;
        }
        VMappingDomainModelReferenceSegment mappingSegment = (VMappingDomainModelReferenceSegment)((IObserving)observableValue).getObserved();
        observableValue.dispose();
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
        Optional<EClass> valueEClass = this.getValueEClass(mappingSegment);
        Set input = valueEClass.map(Collections::singleton).orElseGet(Collections::emptySet);
        Collection subClasses = valueEClass.map(EMFUtils::getSubClasses).orElseGet(Collections::emptySet);
        EClassTreeContentProvider contentProvider = new EClassTreeContentProvider(subClasses);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setAllowMultiple(false);
        dialog.setValidator(selection -> {
            if (selection.length != 0 && EClass.class.isInstance(selection[0])) {
                return Status.OK_STATUS;
            }
            return new Status(4, "org.eclipse.emfforms.ide.view.mappingsegment", "This is not an EClass.");
        });
        dialog.setInput((Object)input);
        dialog.setMessage("Select an EClass.");
        dialog.setTitle("Select an EClass");
        dialog.setComparator(new ViewerComparator());
        int result = dialog.open();
        if (result == 0 && EClass.class.isInstance(selection2 = dialog.getFirstResult())) {
            EClass selectedFeature = (EClass)selection2;
            mappingSegment.setMappedClass(selectedFeature);
        }
        labelProvider.dispose();
    }

    private Optional<EClass> getValueEClass(VMappingDomainModelReferenceSegment mappingSegment) {
        SelectedFeatureViewService service = (SelectedFeatureViewService)this.getViewModelContext().getService(SelectedFeatureViewService.class);
        if (service == null) {
            return Optional.empty();
        }
        EStructuralFeature mapFeature = service.getFeature();
        if (!EReference.class.isInstance(mapFeature)) {
            return Optional.empty();
        }
        EClass referenceMap = ((EReference)EReference.class.cast(mapFeature)).getEReferenceType();
        EStructuralFeature valueFeature = referenceMap.getEStructuralFeature("value");
        if (!EReference.class.isInstance(valueFeature)) {
            return Optional.empty();
        }
        EReference valueReference = (EReference)EReference.class.cast(valueFeature);
        return Optional.ofNullable(valueReference.getEReferenceType());
    }

    private static final class EClassTreeContentProvider
    implements ITreeContentProvider {
        private final Collection<EClass> subClasses;

        EClassTreeContentProvider(Collection<EClass> subClasses) {
            this.subClasses = subClasses;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            if (EClass.class.isInstance(element)) {
                Object[] children = this.getChildren(element);
                return children != null && children.length > 0;
            }
            return false;
        }

        public Object getParent(Object element) {
            if (EClass.class.isInstance(element)) {
                return ((EClass)element).eContainer();
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (EClass.class.isInstance(parentElement)) {
                EClass eClass = (EClass)parentElement;
                List directSubClasses = this.subClasses.stream().filter(c -> c.getESuperTypes().contains((Object)eClass)).collect(Collectors.toList());
                return directSubClasses.toArray();
            }
            if (Collection.class.isInstance(parentElement)) {
                return ((Collection)Collection.class.cast(parentElement)).toArray();
            }
            return null;
        }
    }
}

