/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.common;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class RankingHelper<T> {
    public static final double DEFAULT_INITIAL_RANK = -1.0;
    private final Class<?> elementClass;
    private final double initialRank;
    private final Double ignoreRankValue;

    public RankingHelper(Class<?> elementClass, double initialRank) {
        this(elementClass, initialRank, null);
    }

    public RankingHelper(Class<?> elementClass, double initialRank, Double ignoreRankValue) {
        this.elementClass = elementClass;
        this.initialRank = initialRank;
        this.ignoreRankValue = ignoreRankValue;
    }

    public T getHighestRankingElement(Collection<T> elements, RankTester<T> rankTester) {
        ArrayList<T> highestRankingElements = new ArrayList<T>();
        double highestRank = this.initialRank;
        for (T element : elements) {
            double rank = rankTester.getRank(element);
            if (this.ignoreRankValue != null && Double.doubleToLongBits(this.ignoreRankValue) == Double.doubleToLongBits(rank) || !(rank >= highestRank)) continue;
            if (rank > highestRank) {
                highestRank = rank;
                highestRankingElements.clear();
            }
            highestRankingElements.add(element);
        }
        if (highestRankingElements.size() > 1) {
            this.reportClashingPriorities(this.createWarning(highestRankingElements, highestRank));
        }
        if (highestRankingElements.isEmpty()) {
            return null;
        }
        return (T)highestRankingElements.get(0);
    }

    protected String createWarning(List<T> highestRankingElements, double rank) {
        String warning = "Priority clash while trying to find highest ranking instance of {1}.\nInstance {2} clashes with {3}{4,choice, 0#|0< and {4,number,integer} more}, reporting rank {0,number}.";
        Object[] arguments = new Object[]{rank, this.elementClass, highestRankingElements.get(0).getClass(), highestRankingElements.get(1).getClass(), highestRankingElements.size() - 2};
        return MessageFormat.format("Priority clash while trying to find highest ranking instance of {1}.\nInstance {2} clashes with {3}{4,choice, 0#|0< and {4,number,integer} more}, reporting rank {0,number}.", arguments);
    }

    protected void reportClashingPriorities(String warningMessage) {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        if (bundle != null) {
            BundleContext bundleContext = bundle.getBundleContext();
            ServiceReference serviceReference = bundleContext.getServiceReference(ReportService.class);
            ReportService reportService = (ReportService)bundleContext.getService(serviceReference);
            reportService.report(new AbstractReport(warningMessage, 2));
            bundleContext.ungetService(serviceReference);
        } else {
            System.err.println(warningMessage);
        }
    }

    public static interface RankTester<T> {
        public double getRank(T var1);
    }
}

