/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.domainexpander.mapping;

import java.util.Collection;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.mappingdmr.model.VMappingDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDMRExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsDomainExpander;
import org.eclipse.emfforms.spi.core.services.domainexpander.EMFFormsExpandingFailedException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(name="EMFFormsMappingDMRExpander")
public class EMFFormsMappingDMRExpander
implements EMFFormsDMRExpander {
    private ReportService reportService;
    private EMFFormsDomainExpander domainExpander;
    private BundleContext bundleContext;
    private ServiceReference<EMFFormsDomainExpander> eMFFormsDomainExpanderServiceReference;

    @Reference(unbind="-")
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        if (this.eMFFormsDomainExpanderServiceReference != null) {
            bundleContext.ungetService(this.eMFFormsDomainExpanderServiceReference);
            this.domainExpander = null;
        }
    }

    private EMFFormsDomainExpander getEMFFormsDomainExpander() {
        if (this.domainExpander == null) {
            this.eMFFormsDomainExpanderServiceReference = this.bundleContext.getServiceReference(EMFFormsDomainExpander.class);
            if (this.eMFFormsDomainExpanderServiceReference == null) {
                throw new IllegalStateException("No EMFFormsDomainExpander available!");
            }
            this.domainExpander = (EMFFormsDomainExpander)this.bundleContext.getService(this.eMFFormsDomainExpanderServiceReference);
        }
        return this.domainExpander;
    }

    void setEMFFormsDomainExpander(EMFFormsDomainExpander domainExpander) {
        this.domainExpander = domainExpander;
    }

    public void prepareDomainObject(VDomainModelReference domainModelReference, EObject domainObject) throws EMFFormsExpandingFailedException {
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)domainObject).notNull();
        Assert.create((Object)domainModelReference).ofClass(VMappingDomainModelReference.class);
        VMappingDomainModelReference mappingReference = (VMappingDomainModelReference)domainModelReference;
        if (mappingReference.getDomainModelEFeature() == null) {
            throw new EMFFormsExpandingFailedException("The mapping domain model reference's domain model e feature must not be null.");
        }
        this.checkMapType(mappingReference.getDomainModelEFeature());
        VFeaturePathDomainModelReference firstReference = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
        firstReference.setDomainModelEFeature(mappingReference.getDomainModelEFeature());
        firstReference.getDomainModelEReferencePath().addAll((Collection)mappingReference.getDomainModelEReferencePath());
        this.getEMFFormsDomainExpander().prepareDomainObject((VDomainModelReference)firstReference, domainObject);
        EObject eObject = domainObject;
        for (EReference eRef : firstReference.getDomainModelEReferencePath()) {
            eObject = (EObject)domainObject.eGet((EStructuralFeature)eRef);
        }
        EMap map = (EMap)eObject.eGet(mappingReference.getDomainModelEFeature());
        if (!map.containsKey((Object)mappingReference.getMappedClass())) {
            map.put((Object)mappingReference.getMappedClass(), (Object)EcoreUtil.create((EClass)mappingReference.getMappedClass()));
        }
        EObject mappedEObject = (EObject)map.get((Object)mappingReference.getMappedClass());
        this.getEMFFormsDomainExpander().prepareDomainObject(mappingReference.getDomainModelReference(), mappedEObject);
    }

    public double isApplicable(VDomainModelReference domainModelReference) {
        if (domainModelReference == null) {
            this.reportService.report(new AbstractReport("Warning: The given domain model reference was null."));
            return NOT_APPLICABLE;
        }
        if (VMappingDomainModelReference.class.isInstance(domainModelReference)) {
            return 5.0;
        }
        return NOT_APPLICABLE;
    }

    private void checkMapType(EStructuralFeature structuralFeature) throws EMFFormsExpandingFailedException {
        if (!structuralFeature.getEType().getInstanceClassName().equals("java.util.Map$Entry")) {
            throw new EMFFormsExpandingFailedException("The VMappingDomainModelReference's domainModelEFeature must reference a map.");
        }
        if (structuralFeature.getLowerBound() != 0 || structuralFeature.getUpperBound() != -1) {
            throw new EMFFormsExpandingFailedException("The VMappingDomainModelReference's domainModelEFeature must reference a map.");
        }
        EClass eClass = (EClass)structuralFeature.getEType();
        EStructuralFeature keyFeature = eClass.getEStructuralFeature("key");
        EStructuralFeature valueFeature = eClass.getEStructuralFeature("value");
        if (keyFeature == null || valueFeature == null) {
            throw new EMFFormsExpandingFailedException("The VMappingDomainModelReference's domainModelEFeature must reference a map.");
        }
        if (!EReference.class.isInstance(valueFeature)) {
            throw new EMFFormsExpandingFailedException("The values of the map referenced by the VMappingDomainModelReference's domainModelEFeature must be referenced EObjects.");
        }
        if (!EReference.class.isInstance(keyFeature)) {
            throw new EMFFormsExpandingFailedException("The keys of the map referenced by the VMappingDomainModelReference's domainModelEFeature must be referenced EClasses.");
        }
        if (!EClass.class.isAssignableFrom(((EReference)keyFeature).getEReferenceType().getInstanceClass())) {
            throw new EMFFormsExpandingFailedException("The keys of the map referenced by the VMappingDomainModelReference's domainModelEFeature must be referenced EClasses.");
        }
    }
}

