/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.delegation;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="inlineClass", label="Inline Class", description="In the metamodel, a class reachable through a single-valued containment reference is inlined. More specifically, its features are moved to the source class of the reference. In the model, the values of these features are moved accordingly.", breaking=true)
public class InlineClass
extends OperationImplementation {
    @EdaptParameter(main=true, description="The reference to the class to be inlined")
    public EReference reference;

    @EdaptConstraint(restricts="reference", description="The reference must not have an opposite")
    public boolean checkReference(EReference reference) {
        return reference.getEOpposite() == null;
    }

    @EdaptConstraint(restricts="reference", description="The multiplicity of the reference must be single-valued")
    public boolean checkReferenceSingleValued(EReference reference) {
        return !reference.isMany();
    }

    @EdaptConstraint(restricts="reference", description="The reference must be containment")
    public boolean checkReferenceContainment(EReference reference) {
        return reference.isContainment();
    }

    @EdaptConstraint(description="The class to be inlined must not have sub classes")
    public boolean checkInlinedClassNoSubTypes(Metamodel metamodel) {
        EClass inlinedClass = this.reference.getEReferenceType();
        EList subTypes = metamodel.getInverse((EModelElement)inlinedClass, EcorePackage.eINSTANCE.getEClass_ESuperTypes());
        return subTypes.isEmpty();
    }

    @EdaptConstraint(description="The class to be inlined must not be a type of another reference")
    public boolean checkInlinedClassNotTargetedByReference(Metamodel metamodel) {
        EClass inlinedClass = this.reference.getEReferenceType();
        for (ETypedElement element : metamodel.getInverse((EModelElement)inlinedClass, EcorePackage.eINSTANCE.getETypedElement_EType())) {
            if (!(element instanceof EReference)) continue;
            EReference reference = (EReference)element;
            EReference eOpposite = reference.getEOpposite();
            EList features = inlinedClass.getEStructuralFeatures();
            if (eOpposite == null || features.contains((Object)eOpposite)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        EClass inlinedClass = this.reference.getEReferenceType();
        EClass contextClass = this.reference.getEContainingClass();
        ArrayList features = new ArrayList(inlinedClass.getEStructuralFeatures());
        contextClass.getEStructuralFeatures().addAll(features);
        for (EStructuralFeature feature : features) {
            EReference reference;
            if (!(feature instanceof EReference) || (reference = (EReference)feature).getEOpposite() == null) continue;
            reference.getEOpposite().setEType((EClassifier)contextClass);
        }
        metamodel.delete((EModelElement)this.reference);
        metamodel.delete((EModelElement)inlinedClass);
        for (Instance contextElement : model.getAllInstances(contextClass)) {
            Instance inlinedElement = (Instance)contextElement.unset((EStructuralFeature)this.reference);
            if (inlinedElement == null) continue;
            for (EStructuralFeature feature : features) {
                contextElement.set(feature, inlinedElement.unset(feature));
            }
            model.delete(inlinedElement);
        }
    }
}

