/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.spreadsheet.stream;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emfforms.internal.spreadsheet.stream.messages.Messages;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.spreadsheet.core.EMFFormsSpreadsheetReport;
import org.eclipse.emfforms.spi.spreadsheet.core.error.model.ErrorFactory;
import org.eclipse.emfforms.spi.spreadsheet.core.error.model.Severity;
import org.eclipse.emfforms.spi.spreadsheet.core.error.model.SpreadsheetImportResult;
import org.eclipse.emfforms.spi.spreadsheet.core.transfer.EMFFormsSpreadsheetImporter;
import org.eclipse.emfforms.spi.spreadsheet.stream.EMFFormsSpreadsheetStreamImporter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class EMFFormsSpreadsheetStreamImporterImpl
implements EMFFormsSpreadsheetStreamImporter {
    @Override
    public SpreadsheetImportResult importSpreadsheet(InputStream inputStream, EClass eClass) {
        HSSFWorkbook workbook;
        ServiceReference serviceReference;
        BundleContext bundleContext;
        block12: {
            bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            serviceReference = bundleContext.getServiceReference(ReportService.class);
            ReportService reportService = (ReportService)bundleContext.getService(serviceReference);
            workbook = null;
            try {
                try {
                    workbook = new HSSFWorkbook(inputStream);
                }
                catch (IOException ex) {
                    reportService.report((AbstractReport)new EMFFormsSpreadsheetReport((Throwable)ex, 4));
                    try {
                        inputStream.close();
                    }
                    catch (IOException ex2) {
                        reportService.report((AbstractReport)new EMFFormsSpreadsheetReport((Throwable)ex2, 4));
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    reportService.report((AbstractReport)new EMFFormsSpreadsheetReport((Throwable)ex, 4));
                }
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException ex) {
                reportService.report((AbstractReport)new EMFFormsSpreadsheetReport((Throwable)ex, 4));
            }
        }
        bundleContext.ungetService(serviceReference);
        if (workbook == null) {
            SpreadsheetImportResult result = ErrorFactory.eINSTANCE.createSpreadsheetImportResult();
            result.reportError(Severity.CANCEL, Messages.EMFFormsSpreadsheetStreamImporterImpl_CouldNotCreateWorkbook);
            return result;
        }
        SpreadsheetImportResult result = EMFFormsSpreadsheetImporter.INSTANCE.importSpreadsheet((Workbook)workbook, eClass);
        return result;
    }
}

