/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emfstore.internal.ui;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecp.core.util.ECPCheckoutSource;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.emfstore.core.internal.EMFStoreProjectWrapper;
import org.eclipse.emf.ecp.emfstore.internal.ui.Activator;
import org.eclipse.emf.ecp.emfstore.internal.ui.Messages;
import org.eclipse.emf.ecp.spi.ui.DefaultUIProvider;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESRemoteProject;
import org.eclipse.emf.emfstore.client.exceptions.ESCertificateException;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.KeyStoreManager;
import org.eclipse.emf.emfstore.internal.client.ui.views.emfstorebrowser.views.CertificateSelectionDialog;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EMFStoreUIProvider
extends DefaultUIProvider {
    public EMFStoreUIProvider() {
        super("org.eclipse.emf.ecp.emfstore.provider");
    }

    public <T> T getAdapter(Object adaptable, Class<T> adapterType) {
        if (ESRemoteProject.class.isInstance(adaptable) && adapterType.equals(ESLocalProject.class)) {
            ESRemoteProject checkoutData = (ESRemoteProject)adaptable;
            try {
                return (T)checkoutData.checkout(checkoutData.getProjectName(), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ESException e) {
                Activator.log(e);
            }
            catch (RuntimeException e) {
                Activator.log(e);
            }
        }
        return (T)super.getAdapter(adaptable, adapterType);
    }

    public Control createCheckoutUI(Composite parent, ECPCheckoutSource checkoutSource, ECPProperties projectProperties) {
        return null;
    }

    public Control createAddRepositoryUI(Composite parent, ECPProperties repositoryProperties, Text repositoryNameText, Text repositoryLabelText, Text repositoryDescriptionText) {
        GridLayout mainLayout = new GridLayout(3, false);
        mainLayout.marginWidth = 0;
        mainLayout.marginHeight = 0;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)mainLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label url = new Label(composite, 0);
        url.setText(Messages.EMFStoreUIProvider_URL);
        int mcLabelWidth = parent.getParent().getChildren()[0].getSize().x;
        if (mcLabelWidth > url.getSize().x) {
            GridData gdUrl = new GridData();
            gdUrl.widthHint = mcLabelWidth;
            url.setLayoutData((Object)gdUrl);
        }
        Text urlText = new Text(composite, 2048);
        urlText.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        urlText.addModifyListener(new ModifyListener(){
            private String oldText = "";

            public void modifyText(ModifyEvent e) {
                if (this.oldText.equals(repositoryNameText.getText())) {
                    this.oldText = urlText.getText();
                    repositoryNameText.setText(this.oldText);
                    repositoryProperties.addProperty("repositoryUrl", this.oldText);
                }
            }
        });
        Label port = new Label(composite, 0);
        port.setText(Messages.EMFStoreUIProvider_Port);
        Text portText = new Text(composite, 2048);
        portText.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        portText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                repositoryProperties.addProperty("port", portText.getText());
            }
        });
        Label cert = new Label(composite, 0);
        cert.setText(Messages.EMFStoreUIProvider_Certificate);
        Text certificateText = new Text(composite, 2048);
        certificateText.setEditable(false);
        certificateText.setLayoutData((Object)new GridData(4, 1, true, false));
        Button bSelectCertificate = new Button(composite, 8);
        bSelectCertificate.setText(Messages.EMFStoreUIProvider_SelectCertificate);
        bSelectCertificate.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String certificate = EMFStoreUIProvider.this.selectCertificate();
                certificateText.setText(certificate);
                repositoryProperties.addProperty("certificate", certificateText.getText());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        urlText.setText("localhost");
        portText.setText("8080");
        certificateText.setText(KeyStoreManager.getInstance().getDefaultCertificate());
        repositoryProperties.addProperty("certificate", certificateText.getText());
        return composite;
    }

    private String selectCertificate() {
        CertificateSelectionDialog csd = new CertificateSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof String) {
                    return element.toString();
                }
                return "";
            }
        });
        try {
            ArrayList certificates = KeyStoreManager.getInstance().getCertificates();
            csd.setElements(certificates.toArray());
        }
        catch (ESCertificateException e1) {
            csd.setErrorMessage(e1.getMessage());
        }
        csd.setBlockOnOpen(true);
        csd.setTitle("Certificate Selection Dialog");
        csd.open();
        if (csd.getReturnCode() == 0) {
            return csd.getCertificateAlias();
        }
        return "";
    }

    public String getText(Object element) {
        if (element instanceof EMFStoreProjectWrapper) {
            EMFStoreProjectWrapper emfStoreProjectWrapper = (EMFStoreProjectWrapper)element;
            return emfStoreProjectWrapper.getDefaultCheckoutName();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof EMFStoreProjectWrapper) {
            return ImageDescriptor.createFromURL((URL)Activator.getInstance().getBundle().getResource("icons/projectinfo.png")).createImage();
        }
        return super.getImage(element);
    }
}

