/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.ide.builder;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecp.view.internal.validation.ECPSubstitutionLabelProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.common.internal.validation.ValidationServiceImpl;
import org.eclipse.emfforms.common.spi.validation.ValidationService;
import org.eclipse.emfforms.common.spi.validation.exception.ValidationCanceledException;
import org.eclipse.emfforms.ide.builder.ValidationDelegate;

public class ValidationServiceDelegate
implements ValidationDelegate {
    @Override
    public Optional<Diagnostic> validate(IFile file, IProgressMonitor monitor) {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        ResourceSet rset = null;
        try {
            rset = this.loadModel(file);
            EObject model = this.getModel(rset);
            if (model != null) {
                ValidationServiceImpl service = new ValidationServiceImpl();
                ECPSubstitutionLabelProvider labelProvider = new ECPSubstitutionLabelProvider((AdapterFactory)adapterFactory);
                service.setSubstitutionLabelProvider((EValidator.SubstitutionLabelProvider)labelProvider);
                this.configure((ValidationService)service, rset, model);
                Diagnostic diagnostic = service.validate(model);
                Set subDiagnostics = service.validate((Iterator)model.eAllContents());
                Diagnostician diagnostician = new Diagnostician();
                BasicDiagnostic diagnostics = diagnostician.createDefaultDiagnostic(model);
                if (diagnostic.getSeverity() >= 2) {
                    diagnostics.add(diagnostic);
                }
                for (Diagnostic sub : subDiagnostics) {
                    if (sub.getSeverity() < 2) continue;
                    diagnostics.add(sub);
                }
                Optional optional = Optional.of((Object)diagnostics);
                return optional;
            }
        }
        catch (ClassCastException e) {
            Optional optional = Optional.of((Object)ValidationServiceDelegate.toDiagnostic(e));
            return optional;
        }
        catch (IOException ex) {
            Optional optional = Optional.of((Object)ValidationServiceDelegate.toDiagnostic(ex));
            return optional;
        }
        catch (RuntimeException e) {
            Optional optional = Optional.of((Object)ValidationServiceDelegate.toDiagnostic(e));
            return optional;
        }
        catch (ValidationCanceledException validationCanceledException) {
        }
        finally {
            adapterFactory.dispose();
            if (rset != null) {
                this.unload(rset);
            }
        }
        return Optional.empty();
    }

    protected ResourceSet loadModel(IFile file) throws IOException {
        ResourceSetImpl result = new ResourceSetImpl();
        result.getResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), true);
        return result;
    }

    protected EObject getModel(ResourceSet resourceSet) {
        Resource resource;
        EObject result = null;
        Resource resource2 = resource = resourceSet.getResources().isEmpty() ? null : (Resource)resourceSet.getResources().get(0);
        if (resource != null && !resource.getContents().isEmpty()) {
            result = (EObject)resource.getContents().get(0);
        }
        return result;
    }

    protected void configure(ValidationService validationService, ResourceSet resourceSet, EObject model) {
    }

    protected void unload(ResourceSet resourceSet) {
        for (Resource next : resourceSet.getResources()) {
            next.unload();
            next.eAdapters().clear();
        }
        resourceSet.getResources().clear();
        resourceSet.eAdapters().clear();
    }

    private static Diagnostic toDiagnostic(Throwable throwable) {
        String message = throwable.getClass().getName();
        int index = message.lastIndexOf(46);
        if (index >= 0) {
            message = message.substring(index + 1);
        }
        if (throwable.getLocalizedMessage() != null) {
            message = String.valueOf(message) + ": " + throwable.getLocalizedMessage();
        }
        BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.emfforms.ide.builder", 0, message, new Object[]{throwable});
        if (throwable.getCause() != null && throwable.getCause() != throwable) {
            throwable = throwable.getCause();
            basicDiagnostic.add(ValidationServiceDelegate.toDiagnostic(throwable));
        }
        return basicDiagnostic;
    }
}

