/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.editor.ecore;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecp.common.spi.cachetree.CachedTreeNode;
import org.eclipse.emfforms.spi.swt.treemasterdetail.diagnostic.DiagnosticCache;

public class EcoreDiagnosticCache
extends DiagnosticCache {
    public EcoreDiagnosticCache(Notifier input) {
        super(input);
        LinkedHashSet<EObject> rootObjects = new LinkedHashSet<EObject>();
        if (ResourceSet.class.isInstance(input)) {
            EList resources = ((ResourceSet)ResourceSet.class.cast(input)).getResources();
            resources.stream().map(Resource::getContents).forEach(rootObjects::addAll);
        } else if (Resource.class.isInstance(input)) {
            rootObjects.addAll((Collection<EObject>)((Resource)Resource.class.cast(input)).getContents());
        } else if (EObject.class.isInstance(input)) {
            rootObjects.add((EObject)EObject.class.cast(input));
        } else {
            return;
        }
        rootObjects.forEach(this::depthFirstCacheUpdate);
    }

    private Diagnostic depthFirstCacheUpdate(EObject root) {
        CachedTreeNode treeNode = (CachedTreeNode)this.getNodes().get(root);
        root.eContents().stream().forEach(c -> treeNode.putIntoCache(c, (Object)this.depthFirstCacheUpdate((EObject)c)));
        return (Diagnostic)treeNode.getDisplayValue();
    }

    protected void updateCache(EObject element, DiagnosticCache cache) {
        EObject parent;
        super.updateCache(element, cache);
        if (!this.isInitializing() && (parent = element.eContainer()) != null) {
            this.updateCache(parent, cache);
        }
    }

    protected void updateCacheWithoutRefresh(EObject element, DiagnosticCache cache) {
        EObject parent;
        super.updateCacheWithoutRefresh(element, cache);
        if (!this.isInitializing() && (parent = element.eContainer()) != null) {
            this.updateCacheWithoutRefresh(parent, cache);
        }
    }
}

