/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.util;

import java.util.Arrays;
import org.eclipse.emf.diffmerge.ui.util.DiffMergeLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class DelegatingLabelProvider
extends StyledCellLabelProvider
implements IColorProvider,
IFontProvider,
ILabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private ILabelProvider _delegate;
    protected Font _defaultFont;

    public DelegatingLabelProvider() {
        this(null);
    }

    public DelegatingLabelProvider(ILabelProvider delegate_p) {
        this.setDelegate(delegate_p);
    }

    public void addListener(ILabelProviderListener listener_p) {
        super.addListener(listener_p);
        this.getDelegate().addListener(listener_p);
    }

    public Font getFont(Object element_p) {
        Font result = null;
        if (this._delegate instanceof IFontProvider) {
            result = ((IFontProvider)this._delegate).getFont(element_p);
        }
        if (result == null) {
            result = this._defaultFont;
        }
        return result;
    }

    public Color getBackground(Object element_p) {
        Color result = null;
        if (this._delegate instanceof IColorProvider) {
            result = ((IColorProvider)this._delegate).getBackground(element_p);
        }
        return result;
    }

    protected ILabelProvider getDefaultDelegate() {
        return DiffMergeLabelProvider.getInstance();
    }

    public ILabelProvider getDelegate() {
        return this._delegate;
    }

    public Color getForeground(Object element_p) {
        Color result = null;
        if (this._delegate instanceof IColorProvider) {
            result = ((IColorProvider)this._delegate).getForeground(element_p);
        }
        return result;
    }

    public Image getImage(Object element_p) {
        return this._delegate.getImage(element_p);
    }

    public StyledString getStyledText(Object element_p) {
        StyledString result = null;
        if (this._delegate instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider) {
            result = ((DelegatingStyledCellLabelProvider.IStyledLabelProvider)this._delegate).getStyledText(element_p);
        }
        return result;
    }

    public String getText(Object element_p) {
        return this._delegate.getText(element_p);
    }

    public void removeListener(ILabelProviderListener listener_p) {
        super.removeListener(listener_p);
        this.getDelegate().removeListener(listener_p);
    }

    public void setDelegate(ILabelProvider delegate_p) {
        ILabelProvider old = this._delegate;
        this._delegate = delegate_p;
        if (this._delegate == null) {
            this._delegate = this.getDefaultDelegate();
        }
        if (this._delegate != old) {
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }
    }

    public void update(ViewerCell cell_p) {
        Object[] newStyleRanges;
        Object element = cell_p.getElement();
        StyledString styledText = this.getStyledText(element);
        String newText = styledText == null ? this.getText(element) : styledText.toString();
        Object[] oldStyleRanges = cell_p.getStyleRanges();
        Object[] objectArray = newStyleRanges = this.isOwnerDrawEnabled() && styledText != null ? styledText.getStyleRanges() : null;
        if (!Arrays.equals(oldStyleRanges, newStyleRanges)) {
            cell_p.setStyleRanges((StyleRange[])newStyleRanges);
            if (cell_p.getText().equals(newText)) {
                cell_p.setText("");
            }
        }
        cell_p.setText(newText);
        cell_p.setImage(this.getImage(element));
        cell_p.setBackground(this.getBackground(element));
        cell_p.setForeground(this.getForeground(element));
        this._defaultFont = cell_p.getControl().getFont();
        cell_p.setFont(this.getFont(element));
        this._defaultFont = null;
    }
}

