/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ds.internal.annotations;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.IClasspathContributor;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.ds.internal.annotations.DSAnnotationVersion;
import org.eclipse.pde.ds.internal.annotations.DSLibPluginModelListener;
import org.eclipse.pde.internal.core.WorkspaceModelManager;

public class DSAnnotationClasspathContributor
implements IClasspathContributor {
    private static final IAccessRule[] ANNOTATION_ACCESS_RULES = new IAccessRule[0];
    private static final IClasspathAttribute[] DS_ATTRS = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"org.eclipse.pde.ds.annotations.cp", (String)Boolean.toString(true))};

    public List<IClasspathEntry> getInitialEntries(BundleDescription project) {
        IPluginModelBase model = PluginRegistry.findModel((BundleDescription)project);
        if (model != null) {
            boolean autoClasspath;
            IScopeContext[] scope;
            IResource resource = model.getUnderlyingResource();
            if (resource == null || WorkspaceModelManager.isBinaryProject((IProject)resource.getProject())) {
                return Collections.emptyList();
            }
            IPreferencesService prefs = Platform.getPreferencesService();
            boolean enabled = prefs.getBoolean("org.eclipse.pde.ds.annotations", "enabled", false, scope = new IScopeContext[]{new ProjectScope(resource.getProject()), InstanceScope.INSTANCE, DefaultScope.INSTANCE});
            if (enabled && (autoClasspath = prefs.getBoolean("org.eclipse.pde.ds.annotations", "classpath", true, scope))) {
                String location;
                DSAnnotationVersion specVersion;
                try {
                    specVersion = DSAnnotationVersion.valueOf(prefs.getString("org.eclipse.pde.ds.annotations", "dsVersion", DSAnnotationVersion.V1_3.name(), scope));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    specVersion = DSAnnotationVersion.V1_3;
                }
                String libBundleName = specVersion == DSAnnotationVersion.V1_3 ? "org.eclipse.pde.ds.lib" : "org.eclipse.pde.ds1_2.lib";
                IPluginModelBase bundle = PluginRegistry.findModel((String)libBundleName);
                if (bundle != null && bundle.isEnabled() && (location = bundle.getInstallLocation()) != null) {
                    IPath srcPath = this.getSrcPath(libBundleName);
                    IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)new Path(String.valueOf(location) + "/annotations.jar"), (IPath)srcPath, (IPath)Path.ROOT, (IAccessRule[])ANNOTATION_ACCESS_RULES, (IClasspathAttribute[])DS_ATTRS, (boolean)false);
                    DSLibPluginModelListener.addProject(JavaCore.create((IProject)resource.getProject()), libBundleName);
                    return Collections.singletonList(entry);
                }
            }
            DSLibPluginModelListener.removeProject(JavaCore.create((IProject)resource.getProject()));
        }
        return Collections.emptyList();
    }

    private IPath getSrcPath(String libBundleName) {
        String location;
        IPluginModelBase bundle = PluginRegistry.findModel((String)(String.valueOf(libBundleName) + ".source"));
        if (bundle != null && bundle.isEnabled() && (location = bundle.getInstallLocation()) != null) {
            return new Path(location);
        }
        return null;
    }

    public List<IClasspathEntry> getEntriesForDependency(BundleDescription project, BundleDescription addedDependency) {
        return Collections.emptyList();
    }
}

