/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.reachabilitygraph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.comma.actions.actions.CommandReply;
import org.eclipse.comma.actions.actions.EventCall;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.InAllStatesBlock;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.behavior.component.component.Component;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.impl.InterfaceImpl;
import org.eclipse.comma.evaluator.EClause;
import org.eclipse.comma.evaluator.ECommand;
import org.eclipse.comma.evaluator.EComponentState;
import org.eclipse.comma.evaluator.EConnection;
import org.eclipse.comma.evaluator.EIState;
import org.eclipse.comma.evaluator.EInterfaceState;
import org.eclipse.comma.evaluator.ESignal;
import org.eclipse.comma.evaluator.ETransition;
import org.eclipse.comma.evaluator.EVariable;
import org.eclipse.comma.evaluator.EVariableCollection;
import org.eclipse.comma.evaluator.EVariableType;
import org.eclipse.comma.parameters.parameters.Parameters;
import org.eclipse.comma.reachabilitygraph.Edge;
import org.eclipse.comma.reachabilitygraph.InputParameters;
import org.eclipse.comma.reachabilitygraph.Node;
import org.eclipse.comma.reachabilitygraph.ReachabilityGraph;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.scoping.IScopeProvider;

class ReachabilityGraphBuilder {
    private final EIState initialState;
    private final InputParameters inputParameters;
    private final ReachabilityGraph graph = new ReachabilityGraph();
    private final int maxDepth;
    private final Set<State> coveredStates = new HashSet<State>();
    private final Set<Clause> coveredClauses = new HashSet<Clause>();
    private final Set<String> seenEdgeKeys = new HashSet<String>();
    public boolean built = false;
    public StringBuilder debugInformation;

    public ReachabilityGraphBuilder(Interface itf, int maxDepth, List<Parameters> parametersInputSpecification) {
        this.maxDepth = maxDepth;
        this.inputParameters = new InputParameters(parametersInputSpecification);
        this.initialState = new EInterfaceState(itf);
        this.debugInformation = new StringBuilder();
    }

    public ReachabilityGraphBuilder(Component component, int maxDepth, List<Parameters> parametersInputSpecifications, IScopeProvider scopeProvider, List<EConnection> connections) {
        this.maxDepth = maxDepth;
        if (parametersInputSpecifications == null) {
            parametersInputSpecifications = new ArrayList<Parameters>();
        }
        this.inputParameters = new InputParameters(parametersInputSpecifications);
        this.initialState = new EComponentState(component, scopeProvider, connections);
        this.debugInformation = new StringBuilder();
    }

    public ReachabilityGraph build() {
        if (this.built) {
            throw new RuntimeException("Already built");
        }
        this.debugInformation.append("Legend: S=State, T=Transition, C=Clause.\nThe number after C a unique ID, the lookup at the bottom shows the actions of the clause.\nWith each new S (State) the depth is increased by one.\nEdges are only added to the graph when a full sequence of S -> T -> C can be made (look for 'adding to graph').\nWhenever you see 'Done' in the line; traversal is stopped; the line will include the reason for it.\n\n\n");
        this.graph.initial = this.graph.getOrCreateNode(ReachabilityGraphBuilder.getNodeName(this.initialState), ReachabilityGraphBuilder.getStateName(this.initialState), null);
        this.graph.depth = 0;
        this.graph.maxDepth = this.maxDepth;
        this.walkRecursive(this.initialState, 0);
        this.graph.coveredClauses = this.coveredClauses.size();
        this.graph.coveredStates = this.coveredStates.size();
        this.graph.totalClauses = this.initialState.countClauses();
        this.graph.totalStates = this.initialState.countStates();
        this.built = true;
        this.addCoveredClausesToDebug();
        this.graph.builderDebugLog = this.cleanupDebugInformation();
        return this.graph;
    }

    private void addCoveredClausesToDebug() {
        this.debugInformation.append("\n\n");
        for (Clause clause : this.coveredClauses) {
            String trigger = clause.eContainer() instanceof TriggeredTransition ? ((TriggeredTransition)clause.eContainer()).getTrigger().getName() : "NonTriggered";
            EObject state = clause.eContainer().eContainer();
            String stateStr = state instanceof InAllStatesBlock ? "InAllStates" : ((State)state).getName();
            StateMachine machine = (StateMachine)state.eContainer();
            Interface itf = (Interface)machine.eContainer();
            String clauseStr = clause.getActions() == null ? "" : String.join((CharSequence)" - ", clause.getActions().getActions().stream().map(a -> {
                if (a instanceof CommandReply) {
                    return "Reply";
                }
                if (a instanceof EventCall) {
                    return ((EventCall)a).getEvent().getName();
                }
                return "";
            }).filter(e -> !e.isEmpty()).collect(Collectors.toList()));
            this.debugInformation.append(String.format("- %d: %s.%s.%s - %s\n", clause.hashCode(), itf.getName(), stateStr, trigger, clauseStr));
        }
    }

    private static String getStateName(EIState state) {
        return String.join((CharSequence)"_", state.getCurrentStates().stream().map(s -> s.getName()).collect(Collectors.toList()));
    }

    private static String variableToString(EVariable variable) {
        if (variable.value == null) {
            return "null";
        }
        if (variable.type == EVariableType.VECTOR) {
            String value = variable.getValueVector().stream().map(v -> ReachabilityGraphBuilder.variableToString(v)).collect(Collectors.joining("_"));
            return String.format("[%s]", value);
        }
        if (variable.type == EVariableType.RECORD) {
            String value = variable.getValueRecord().entrySet().stream().map(e -> String.format("%s_%s", e.getKey(), ReachabilityGraphBuilder.variableToString((EVariable)e.getValue()))).collect(Collectors.joining("_"));
            return String.format("{%s}", value);
        }
        if (variable.type == EVariableType.MAP) {
            String value = variable.getValueMap().entrySet().stream().map(e -> String.format("%s_%s", ReachabilityGraphBuilder.variableToString((EVariable)e.getKey()), ReachabilityGraphBuilder.variableToString((EVariable)e.getValue()))).collect(Collectors.joining("_"));
            return String.format("{%s}", value);
        }
        return variable.value.toString();
    }

    private static String getNodeName(EIState state) {
        Function<EInterfaceState, String> getNodeNameInterfaceState = s -> {
            String name = ReachabilityGraphBuilder.getStateName((EIState)s);
            EVariableCollection variables = s.getVariables();
            for (String variableName : variables.allNamesSorted()) {
                name = String.valueOf(name) + "_" + ReachabilityGraphBuilder.variableToString(variables.get(variableName));
            }
            if (s.transition != null) {
                name = s.transition.transition instanceof TriggeredTransition ? String.valueOf(name) + "_Triggered_" + ((TriggeredTransition)s.transition.transition).getTrigger().getName() : String.valueOf(name) + "_NonTriggered";
            }
            return name;
        };
        if (state instanceof EComponentState) {
            return String.join((CharSequence)"__", ((EComponentState)state).connections.entrySet().stream().map(e -> String.format("%s_%s_%s", ((EConnection)e.getKey()).port, ((EConnection)e.getKey()).id, getNodeNameInterfaceState.apply((EInterfaceState)e.getValue()))).collect(Collectors.toList()));
        }
        return getNodeNameInterfaceState.apply((EInterfaceState)state);
    }

    private static String getStartToIntermediateEdgeKey(String startNode, String intermediateNode, int transitionIndex, ETransition transition, EClause clause) {
        String connection = transition.connection == null ? "" : String.format("%s_%s", transition.connection.port, transition.connection.id);
        return String.format("%s_%s_%s_%d_%d", connection, startNode, intermediateNode, transitionIndex, transition.transition.getClauses().indexOf((Object)clause.clause));
    }

    private List<EVariableCollection> getParameters(ETransition transition) {
        TriggeredTransition t;
        String itf;
        List<EVariableCollection> parameters = new ArrayList<EVariableCollection>();
        if (transition.transition instanceof TriggeredTransition && this.inputParameters.hasParametersSet(itf = ((InterfaceImpl)transition.machine.eContainer()).getName(), (t = (TriggeredTransition)transition.transition).getTrigger().getName(), transition.state.getName())) {
            parameters = this.inputParameters.getParametersSet(itf, t.getTrigger().getName(), transition.state.getName());
        }
        if (parameters.isEmpty()) {
            parameters.add(new EVariableCollection());
        }
        return parameters;
    }

    public String debugPrefix(int depth, int localDepth) {
        String prefix = "|";
        int i = 0;
        while (i < depth) {
            prefix = String.valueOf(prefix) + " | | |";
            ++i;
        }
        i = 0;
        while (i < localDepth) {
            prefix = String.valueOf(prefix) + " |";
            ++i;
        }
        return String.valueOf(prefix) + "-";
    }

    public String cleanupDebugInformation() {
        List<String> lines = Arrays.asList(this.debugInformation.toString().split("\n"));
        ArrayList<String> result = new ArrayList<String>();
        int lineIndex = 0;
        while (lineIndex < lines.size()) {
            StringBuilder line = new StringBuilder(lines.get(lineIndex));
            int charIndex = 0;
            while (charIndex < line.length()) {
                if (line.charAt(charIndex) == '|' && line.charAt(charIndex + 1) == ' ') {
                    boolean isLastOfTree = true;
                    int otherLineIndex = lineIndex + 1;
                    while (otherLineIndex < lines.size()) {
                        int otherLineIndent = lines.get(otherLineIndex).indexOf("|-");
                        if (otherLineIndent < charIndex) break;
                        if (otherLineIndent == charIndex) {
                            isLastOfTree = false;
                            break;
                        }
                        ++otherLineIndex;
                    }
                    if (isLastOfTree) {
                        line.setCharAt(charIndex, ' ');
                    }
                }
                ++charIndex;
            }
            result.add(line.toString());
            ++lineIndex;
        }
        return String.join((CharSequence)"\n", result);
    }

    public String debugTransitionToString(ETransition transition, EVariableCollection parameters) {
        String name;
        String string = name = transition.connection == null ? "" : String.format("%s_%s", transition.connection.port, transition.connection.id);
        if (transition.transition instanceof TriggeredTransition) {
            name = String.valueOf(name) + "_Triggered_" + ((TriggeredTransition)transition.transition).getTrigger().getName();
            name = String.valueOf(name) + ", parameters: ";
            name = String.valueOf(name) + String.join((CharSequence)", ", parameters.allNamesSorted().stream().map(p -> String.valueOf(p) + ":" + eVariableCollection.get((String)p).value.toString()).collect(Collectors.toList()));
        } else {
            name = String.valueOf(name) + "_NonTriggered";
        }
        return name;
    }

    public void walkRecursive(EIState startState, int depth) {
        if (depth > this.maxDepth) {
            return;
        }
        if (this.graph.depth < depth) {
            this.graph.depth = depth;
        }
        this.coveredStates.addAll(startState.getCurrentStates());
        Node startNode = this.graph.getOrCreateNode(ReachabilityGraphBuilder.getNodeName(startState), ReachabilityGraphBuilder.getStateName(startState), null);
        this.debugInformation.append(String.valueOf(this.debugPrefix(depth, 0)) + "S:" + ReachabilityGraphBuilder.getNodeName(startState) + ", depth: " + depth);
        List transitions = startState.possibleTransitions();
        if (transitions.isEmpty()) {
            this.debugInformation.append(String.format(" => Done, no transitions possible\n", new Object[0]));
        } else {
            this.debugInformation.append("\n");
        }
        for (ETransition transition : transitions) {
            for (EVariableCollection parameters : this.getParameters(transition)) {
                this.debugInformation.append(String.valueOf(this.debugPrefix(depth, 1)) + "T:" + this.debugTransitionToString(transition, parameters));
                EIState intermediateState = startState.takeTransition(transition, parameters);
                List clauses = intermediateState.possibleClauses();
                if (clauses.isEmpty()) {
                    this.debugInformation.append(String.format(" => Done, no clauses possible\n", new Object[0]));
                } else {
                    this.debugInformation.append("\n");
                }
                for (EClause clause : clauses) {
                    this.debugInformation.append(String.valueOf(this.debugPrefix(depth, 2)) + "C:" + clause.clause.hashCode());
                    this.coveredClauses.add(clause.clause);
                    EIState endState = intermediateState.takeClause(clause);
                    String intermediateName = ReachabilityGraphBuilder.getNodeName(intermediateState);
                    String edgeKey = ReachabilityGraphBuilder.getStartToIntermediateEdgeKey(startNode.name, intermediateName, transitions.indexOf(transition), transition, clause);
                    if (!this.seenEdgeKeys.contains(edgeKey)) {
                        this.seenEdgeKeys.add(edgeKey);
                        this.debugInformation.append(String.format(" => Edge key '%s', adding to graph", edgeKey));
                        if (depth + 1 > this.maxDepth) {
                            this.debugInformation.append(", done, max depth reached\n");
                        } else {
                            this.debugInformation.append("\n");
                        }
                        Node endNode = this.graph.getOrCreateNode(ReachabilityGraphBuilder.getNodeName(endState), ReachabilityGraphBuilder.getStateName(endState), null);
                        if (!intermediateState.getActions().isEmpty()) {
                            Object trigger = intermediateState.getActions().get(0);
                            String triggerName = trigger instanceof ECommand ? ((ECommand)trigger).method : ((ESignal)trigger).method;
                            Node intermediateNode = this.graph.getOrCreateNode(intermediateName, startNode.state, triggerName);
                            Optional<Edge> startToIntermediate = this.graph.getEdge(startNode, intermediateNode);
                            if (!startToIntermediate.isPresent()) {
                                this.graph.createEdge((Node)startNode, (Node)intermediateNode).entries = intermediateState.getActions();
                            }
                            Edge intermediateToEnd = this.graph.createEdge(intermediateNode, endNode);
                            intermediateToEnd.entries = endState.getActions();
                        } else {
                            Edge startToEnd = this.graph.createEdge(startNode, endNode);
                            startToEnd.entries = endState.getActions();
                        }
                        this.walkRecursive(endState, depth + 1);
                        continue;
                    }
                    this.debugInformation.append(String.format(" => Done, edge key '%s' already found\n", edgeKey));
                }
            }
        }
    }
}

