/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.evaluator;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.ActionList;
import org.eclipse.comma.actions.actions.AssignmentAction;
import org.eclipse.comma.actions.actions.IfAction;
import org.eclipse.comma.actions.actions.PCElement;
import org.eclipse.comma.actions.actions.PCFragmentDefinition;
import org.eclipse.comma.actions.actions.PCFragmentReference;
import org.eclipse.comma.actions.actions.ParallelComposition;
import org.eclipse.comma.actions.actions.RecordFieldAssignmentAction;
import org.eclipse.comma.actions.actions.impl.CommandReplyImpl;
import org.eclipse.comma.actions.actions.impl.EventCallImpl;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.InAllStatesBlock;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.behavior.Transition;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.evaluator.EAction;
import org.eclipse.comma.evaluator.EArgument;
import org.eclipse.comma.evaluator.EClause;
import org.eclipse.comma.evaluator.ECommand;
import org.eclipse.comma.evaluator.EIState;
import org.eclipse.comma.evaluator.ENotification;
import org.eclipse.comma.evaluator.EReply;
import org.eclipse.comma.evaluator.ESignal;
import org.eclipse.comma.evaluator.ETransition;
import org.eclipse.comma.evaluator.EVariable;
import org.eclipse.comma.evaluator.EVariableCollection;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionRecordAccess;
import org.eclipse.comma.expressions.expression.ExpressionVariable;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signal;
import org.eclipse.comma.signature.interfaceSignature.impl.CommandImpl;
import org.eclipse.comma.signature.interfaceSignature.impl.SignalImpl;
import org.eclipse.emf.common.util.EList;

public class EInterfaceState
implements EIState {
    public final List<EAction> actions = new ArrayList<EAction>();
    private final EVariableCollection globalVariables;
    private EVariableCollection localVariables;
    public final EInterfaceState previous;
    public final ETransition transition;
    public final LinkedHashMap<StateMachine, State> states;

    private EInterfaceState(EVariableCollection globalVariables, EVariableCollection localVariables, EInterfaceState previous, ETransition transition, LinkedHashMap<StateMachine, State> states) {
        this.globalVariables = globalVariables;
        this.localVariables = localVariables;
        this.previous = previous;
        this.transition = transition;
        this.states = states;
    }

    public EInterfaceState(Interface itf) {
        this.states = new LinkedHashMap();
        itf.getMachines().forEach(m -> {
            State state = m.getStates().stream().filter(s -> s.isInitial()).findFirst().get();
            this.states.put((StateMachine)m, state);
        });
        this.globalVariables = new EVariableCollection();
        this.transition = null;
        this.previous = null;
        itf.getVars().forEach(v -> this.globalVariables.add((Variable)v));
        itf.getInitActions().forEach(a -> EInterfaceState.handle(this, a, 0));
    }

    @Override
    public List<ETransition> possibleTransitions() {
        if (this.transition != null) {
            throw new RuntimeException("Taking transition not allowed");
        }
        ArrayList<ETransition> transitions = new ArrayList<ETransition>();
        for (Map.Entry<StateMachine, State> entry : this.states.entrySet()) {
            State state = entry.getValue();
            StateMachine machine = entry.getKey();
            transitions.addAll(state.getTransitions().stream().map(t -> new ETransition((Transition)t, state, machine)).collect(Collectors.toList()));
            for (InAllStatesBlock inAllStates : machine.getInAllStates()) {
                if (inAllStates.getExcludedStates().contains((Object)state)) continue;
                transitions.addAll(inAllStates.getTransitions().stream().map(t -> new ETransition((Transition)t, state, machine)).collect(Collectors.toList()));
            }
        }
        return transitions;
    }

    @Override
    public EInterfaceState takeTransition(ETransition transition, EVariableCollection triggerParameters) {
        if (!this.possibleTransitions().stream().anyMatch(t -> t.transition == eTransition.transition)) {
            throw new RuntimeException("Not allowed transition");
        }
        EInterfaceState nextState = new EInterfaceState(this.globalVariables.clone(), new EVariableCollection(), this, transition, this.states);
        if (transition.transition instanceof TriggeredTransition) {
            TriggeredTransition t2 = (TriggeredTransition)transition.transition;
            InterfaceEvent trigger = t2.getTrigger();
            List parameterNames = ((TriggeredTransition)transition.transition).getParameters().stream().map(v -> v.getName()).collect(Collectors.toList());
            EList parameters = trigger instanceof CommandImpl ? ((CommandImpl)trigger).getParameters() : ((SignalImpl)trigger).getParameters();
            for (Parameter parameter : parameters) {
                EVariable variable = null;
                if (parameter.getDirection() == DIRECTION.IN || parameter.getDirection() == DIRECTION.INOUT) {
                    if (!triggerParameters.has(parameter.getName())) {
                        throw new RuntimeException(String.format("No parameter for '%s' argument '%s' in state '%s'", trigger.getName(), parameter.getName(), transition.state.getName()));
                    }
                    variable = triggerParameters.get(parameter.getName());
                } else {
                    variable = EVariable.fromType(parameter.getType().getType());
                }
                String parameterName = (String)parameterNames.get(parameters.indexOf(parameter));
                nextState.localVariables.add(parameterName, variable);
            }
            EInterfaceState.handle(nextState, ((TriggeredTransition)transition.transition).getTrigger(), 0);
        }
        return nextState;
    }

    @Override
    public List<EClause> possibleClauses() {
        boolean guardIsTrue;
        if (this.transition == null) {
            throw new RuntimeException("Taking clause not allowed");
        }
        boolean bl = guardIsTrue = this.transition.transition.getGuard() == null || EVariable.fromExpression(this.transition.transition.getGuard(), this.getVariables()).getValueBool();
        if (guardIsTrue) {
            return this.transition.transition.getClauses().stream().map(c -> new EClause((Clause)c)).collect(Collectors.toList());
        }
        return new ArrayList<EClause>();
    }

    @Override
    public EInterfaceState takeClause(EClause clause) {
        if (!this.possibleClauses().stream().anyMatch(t -> t.clause == eClause.clause)) {
            throw new RuntimeException("Not allowed clause");
        }
        LinkedHashMap<StateMachine, State> states = new LinkedHashMap<StateMachine, State>(this.states);
        State targetState = clause.clause.getTarget() != null ? clause.clause.getTarget() : states.get(this.transition.machine);
        states.put(this.transition.machine, targetState);
        EInterfaceState nextState = new EInterfaceState(this.globalVariables.clone(), this.localVariables.clone(), this, null, states);
        if (clause.clause.getActions() != null) {
            for (Action action : clause.clause.getActions().getActions()) {
                EInterfaceState.handle(nextState, action, EInterfaceState.getNextOrder(nextState));
            }
        }
        nextState.localVariables = null;
        return nextState;
    }

    public void setVariable(String name, EVariable variable) {
        if (this.globalVariables.has(name)) {
            this.globalVariables.put(name, variable);
        } else if (this.localVariables.has(name)) {
            this.localVariables.put(name, variable);
        } else {
            throw new RuntimeException(String.format("Undefined variable '%s'", name));
        }
    }

    public EVariableCollection getVariables() {
        return this.localVariables != null ? this.globalVariables.combine(this.localVariables) : this.globalVariables;
    }

    @Override
    public int countStates() {
        return this.states.keySet().stream().map(m -> m.getStates().size()).reduce(0, Integer::sum);
    }

    @Override
    public int countClauses() {
        return this.states.keySet().stream().map(m -> m.getStates().stream().map(s -> s.getTransitions().stream().map(t -> t.getClauses().size()).reduce(0, Integer::sum)).reduce(0, Integer::sum) + m.getInAllStates().stream().map(s -> s.getTransitions().stream().map(t -> t.getClauses().size()).reduce(0, Integer::sum)).reduce(0, Integer::sum)).reduce(0, Integer::sum);
    }

    @Override
    public List<State> getCurrentStates() {
        return this.states.values().stream().collect(Collectors.toList());
    }

    @Override
    public List<EAction> getActions() {
        return this.actions;
    }

    private static int getNextOrder(EInterfaceState state) {
        if (state.actions.size() == 0) {
            return 0;
        }
        EAction last = state.actions.get(state.actions.size() - 1);
        if (last instanceof ENotification) {
            return ((ENotification)last).order + 1;
        }
        return ((EReply)last).order + 1;
    }

    private static void handle(EInterfaceState state, Object action, Integer order) {
        if (action instanceof CommandImpl) {
            CommandImpl a = (CommandImpl)action;
            ECommand command = new ECommand(a.getName(), a.getType().getType().getName());
            EList parameters = ((TriggeredTransition)state.transition.transition).getParameters();
            for (Variable parameter : parameters) {
                String name = parameter.getName();
                EVariable variable = state.getVariables().get(name);
                String direction = ((Parameter)a.getParameters().get(parameters.indexOf(parameter))).getDirection().getLiteral();
                command.arguments.add(new EArgument(name, variable, direction));
            }
            state.actions.add(command);
        } else if (action instanceof Signal) {
            Signal a = (Signal)action;
            ESignal signal = new ESignal(a.getName());
            EList parameters = ((TriggeredTransition)state.transition.transition).getParameters();
            for (Variable parameter : parameters) {
                String name = parameter.getName();
                EVariable variable = state.getVariables().get(name);
                String direction = ((Parameter)a.getParameters().get(parameters.indexOf(parameter))).getDirection().getLiteral();
                signal.arguments.add(new EArgument(name, variable, direction));
            }
            state.actions.add(signal);
        } else if (action instanceof CommandReplyImpl) {
            ECommand command = (ECommand)state.previous.actions.get(0);
            EVariable returnValue = null;
            EVariableCollection variables = state.getVariables();
            ArrayList parameters = new ArrayList(((CommandReplyImpl)action).getParameters());
            if (!command.type.equals("void")) {
                Expression lastParameter = (Expression)parameters.get(parameters.size() - 1);
                returnValue = EVariable.fromExpression(lastParameter, variables);
                parameters.remove(lastParameter);
            }
            EReply reply = new EReply(command.method, returnValue, order);
            for (Expression parameter : parameters) {
                reply.arguments.add(new EArgument(EVariable.fromExpression(parameter, variables), "out"));
            }
            state.actions.add(reply);
        } else if (action instanceof EventCallImpl) {
            EventCallImpl a = (EventCallImpl)action;
            String occurrence = "";
            if (a.getOccurence() != null) {
                occurrence = a.getOccurence();
            } else if (a.getMultiplicity() != null) {
                occurrence = "[" + Long.toString(a.getMultiplicity().getLower());
                if (a.getMultiplicity().getUpper() != 0L) {
                    occurrence = String.valueOf(occurrence) + "-" + Long.toString(a.getMultiplicity().getUpper());
                } else if (a.getMultiplicity().getUpperInf() != null) {
                    occurrence = String.valueOf(occurrence) + "-" + a.getMultiplicity().getUpperInf();
                }
                occurrence = String.valueOf(occurrence) + "]";
            }
            ENotification notification = new ENotification(a.getEvent().getName(), order, occurrence);
            EVariableCollection variables = state.getVariables();
            for (Expression parameter : a.getParameters()) {
                notification.arguments.add(new EArgument(EVariable.fromExpression(parameter, variables), "out"));
            }
            state.actions.add(notification);
        } else if (action instanceof AssignmentAction) {
            AssignmentAction a = (AssignmentAction)action;
            state.setVariable(a.getAssignment().getName(), EVariable.fromExpression(a.getExp(), state.getVariables()));
        } else if (action instanceof IfAction) {
            IfAction a = (IfAction)action;
            ActionList actions = null;
            if (EVariable.fromExpression(a.getGuard(), state.getVariables()).getValueBool()) {
                actions = a.getThenList();
            } else if (a.getElseList() != null) {
                actions = a.getElseList();
            }
            if (actions != null) {
                for (Action aa : actions.getActions()) {
                    EInterfaceState.handle(state, aa, EInterfaceState.getNextOrder(state));
                }
            }
        } else if (action instanceof RecordFieldAssignmentAction) {
            RecordFieldAssignmentAction a = (RecordFieldAssignmentAction)action;
            ExpressionRecordAccess access = (ExpressionRecordAccess)a.getFieldAccess();
            String key = access.getField().getName();
            EVariable value = EVariable.fromExpression(a.getExp(), state.getVariables());
            EVariable record = EVariable.fromExpression(access.getRecord(), state.getVariables());
            LinkedHashMap<String, EVariable> newValue = new LinkedHashMap<String, EVariable>(record.getValueRecord());
            newValue.put(key, value);
            ExpressionVariable e = (ExpressionVariable)access.getRecord();
            state.setVariable(e.getVariable().getName(), record.clone(newValue));
        } else if (action instanceof ParallelComposition) {
            ParallelComposition a = (ParallelComposition)action;
            for (PCElement e : a.getComponents()) {
                EInterfaceState.handle(state, e, order);
            }
        } else if (action instanceof PCFragmentReference) {
            PCFragmentReference a = (PCFragmentReference)action;
            PCFragmentDefinition d = a.getFragment();
            for (PCElement e : d.getComponents()) {
                EInterfaceState.handle(state, e, order);
            }
        } else {
            throw new RuntimeException("Not supported");
        }
    }
}

