/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ui.commands.importer;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.polarsys.capella.common.ui.services.commands.AbstractUiHandler;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.vp.requirements.importer.transposer.launcher.RequirementsImportLauncher;
import org.polarsys.capella.vp.requirements.ui.commands.RequirementsVPUICommandsPlugin;

public class ReqIFImportCommandHandler
extends AbstractUiHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List selection = this.getSelection(event, EObject.class);
        if (selection != null && selection.size() > 0) {
            for (EObject semanticElement : selection) {
                if (semanticElement instanceof BlockArchitecture) {
                    URI file = this.getReqIFFileURI(event);
                    if (file == null) continue;
                    this.run(file, (BlockArchitecture)semanticElement);
                    continue;
                }
                RequirementsVPUICommandsPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.vp.requirements.ui.commands", "Invalid selection"));
            }
        }
        return null;
    }

    protected Shell getActiveShell(ExecutionEvent event) {
        IWorkbenchPart part = (IWorkbenchPart)this.getVariableValue(event, "activePart");
        if (part == null) {
            return RequirementsVPUICommandsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        return part.getSite().getShell();
    }

    protected void run(URI model, BlockArchitecture target) {
        new RequirementsImportLauncher().launch(model, target, (IProgressMonitor)new NullProgressMonitor());
    }

    protected URI getReqIFFileURI(ExecutionEvent event) {
        FileDialog fileDialog = new FileDialog(this.getActiveShell(event), 4);
        fileDialog.setFilterExtensions(new String[]{"*.reqif"});
        fileDialog.setFilterNames(new String[]{"ReqIF files"});
        String filepath = fileDialog.open();
        if (filepath != null) {
            return URI.createFileURI((String)filepath);
        }
        return null;
    }
}

