/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ui.importer.preferences.internal;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPropertyListener;
import org.polarsys.capella.vp.requirements.importer.extension.AttributeSet;
import org.polarsys.capella.vp.requirements.importer.extension.ImportPreferencesModel;
import org.polarsys.capella.vp.requirements.ui.importer.preferences.attributes.AttributesSelectionContentProvider;
import org.polarsys.capella.vp.requirements.ui.importer.preferences.attributes.AttributesSelectionLabelProvider;
import org.polarsys.capella.vp.requirements.ui.importer.preferences.attributes.AttributesSelectionStateProvider;
import org.polarsys.capella.vp.requirements.ui.importer.preferences.internal.messages.Messages;
import org.polarsys.capella.vp.requirements.ui.importer.preferences.util.SWTUtil;

public class AttributesSelectionSection
implements IPropertyListener {
    private CheckboxTreeViewer treeViewer;
    private ImportPreferencesModel model;

    public AttributesSelectionSection(ImportPreferencesModel rootNode) {
        this.model = rootNode;
    }

    public Composite createComposite(Composite parent) {
        Group grp = SWTUtil.createGroup(parent, Messages.select_attributes_import, (Layout)new GridLayout(2, false), new GridData(4, 4, true, true));
        this.treeViewer = new CheckboxTreeViewer((Composite)grp);
        this.treeViewer.setContentProvider((IContentProvider)new AttributesSelectionContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AttributesSelectionLabelProvider());
        this.treeViewer.setCheckStateProvider((ICheckStateProvider)new AttributesSelectionStateProvider());
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object eventElement = event.getElement();
                if (eventElement instanceof AttributeSet) {
                    AttributeSet attributeSet = (AttributeSet)eventElement;
                    if (attributeSet.isMandatory() && !event.getChecked()) {
                        event.getCheckable().setChecked((Object)attributeSet, true);
                    } else {
                        AttributesSelectionSection.this.updateCheckState(attributeSet, event.getChecked());
                        AttributesSelectionSection.this.treeViewer.refresh();
                    }
                }
            }
        });
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.verticalSpan = 2;
        this.treeViewer.getControl().setLayoutData((Object)layoutData);
        this.treeViewer.setInput((Object)this.model);
        final Button selectAll = SWTUtil.createButton((Composite)grp, 8, Messages.select_all, new GridData(4, 1, false, false));
        Button deselectAll = SWTUtil.createButton((Composite)grp, 8, Messages.deselect_all, new GridData(4, 1, false, false));
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AttributesSelectionSection.this.model.selectAll(event.getSource() == selectAll);
                AttributesSelectionSection.this.treeViewer.refresh();
            }
        };
        selectAll.addSelectionListener((SelectionListener)selectionListener);
        deselectAll.addSelectionListener((SelectionListener)selectionListener);
        return grp;
    }

    public void performDefaults(IPreferenceStore preferenceStore) {
        this.model.resetToDefaultSelection();
        this.treeViewer.refresh();
    }

    private void updateCheckState(AttributeSet attributeSet, boolean isCheckd) {
        attributeSet.setSelected(isCheckd);
        for (AttributeSet childAttr : attributeSet.getChildren()) {
            this.updateCheckState(childAttr, isCheckd);
        }
    }

    public void propertyChanged(Object source, int propId) {
        this.treeViewer.refresh();
    }
}

