/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.equinox.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class EMFCodeGenRunner {
    public void generateAll(List<URI> modelURIS, final Monitor monitor) throws CoreException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Map result = null;
        try {
            Method computePlatformURIMap = EcorePlugin.class.getMethod("computePlatformURIMap", Boolean.TYPE);
            result = (Map)computePlatformURIMap.invoke(null, true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        if (result == null) {
            result = EcorePlugin.computePlatformURIMap();
        }
        if (result != null) {
            resourceSet.getURIConverter().getURIMap().putAll(result);
        }
        final Generator generator = new Generator();
        final ArrayList<GenModel> genmodels = new ArrayList<GenModel>();
        for (URI uri : modelURIS) {
            Resource res = resourceSet.getResource(uri, true);
            if (res == null) continue;
            for (EObject root : res.getContents()) {
                if (!(root instanceof GenModel)) continue;
                genmodels.add((GenModel)root);
            }
        }
        final ArrayList diagnostics = new ArrayList();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor progressMonitor) throws CoreException {
                for (GenModel genModel : genmodels) {
                    genModel.setCanGenerate(true);
                    generator.setInput((Object)genModel);
                    if (genModel.getModelDirectory() != null && genModel.getModelDirectory().length() > 0) {
                        diagnostics.add(generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", monitor));
                    }
                    if (genModel.getEditDirectory() != null && genModel.getEditDirectory().length() > 0) {
                        diagnostics.add(generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", monitor));
                    }
                    if (genModel.getEditorDirectory() == null || genModel.getEditorDirectory().length() <= 0) continue;
                    diagnostics.add(generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject", monitor));
                }
            }
        };
        workspace.run(runnable, BasicMonitor.toIProgressMonitor((Monitor)monitor));
    }
}

