/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.evaluation.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Map;
import org.eclipse.acceleo.aql.evaluation.writer.IAcceleoWriter;
import org.eclipse.emf.common.util.URI;

public abstract class AbstractAcceleoWriter
implements IAcceleoWriter {
    private final URI targetURI;
    private final Charset charset;
    private static final int INITIAL_SIZE = 1024;
    private final StringBuilder builder = new StringBuilder(1024);
    private String lineDelimiter;
    private final Map<URI, String> preview;

    public AbstractAcceleoWriter(URI targetURI, Charset charset, String linedelimiter, Map<URI, String> preview) {
        this.targetURI = targetURI;
        this.charset = charset;
        this.lineDelimiter = linedelimiter;
        this.preview = preview;
    }

    @Override
    public void append(String content) {
        this.builder.append(content);
    }

    @Override
    public URI getTargetURI() {
        return this.targetURI;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    protected StringBuilder getBuilder() {
        return this.builder;
    }

    @Override
    public void close() throws IOException {
        String content = this.getContent();
        if (content != null) {
            if (this.preview != null) {
                this.preview.put(this.targetURI, content);
            } else {
                Throwable throwable = null;
                Object var3_4 = null;
                try (OutputStream output = this.createOutputStream();){
                    output.write(content.getBytes(this.getCharset()));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
    }

    protected abstract OutputStream createOutputStream() throws IOException;

    protected String getContent() throws IOException {
        return this.getBuilder().toString();
    }
}

