/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.acceleo.query.ast.And;
import org.eclipse.acceleo.query.ast.Binding;
import org.eclipse.acceleo.query.ast.BooleanLiteral;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.ClassTypeLiteral;
import org.eclipse.acceleo.query.ast.Conditional;
import org.eclipse.acceleo.query.ast.EClassifierTypeLiteral;
import org.eclipse.acceleo.query.ast.EnumLiteral;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.Implies;
import org.eclipse.acceleo.query.ast.IntegerLiteral;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.ast.NullLiteral;
import org.eclipse.acceleo.query.ast.Or;
import org.eclipse.acceleo.query.ast.RealLiteral;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.acceleo.query.ast.SetInExtensionLiteral;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.TypeSetLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.util.AstSwitch;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.EvaluationServices;
import org.eclipse.acceleo.query.runtime.impl.LambdaValue;
import org.eclipse.acceleo.query.runtime.impl.Nothing;
import org.eclipse.acceleo.query.runtime.impl.NullValue;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;

public class AstEvaluator
extends AstSwitch<Object> {
    private static final String BAD_PREDICATE_TYPE_MSG = "Conditional's predicate must evaluate to a boolean value but was %s instead.";
    private final Deque<Map<String, Object>> variablesStack = new ArrayDeque<Map<String, Object>>();
    private final EvaluationServices services;
    private Diagnostic diagnostic;

    public AstEvaluator(IReadOnlyQueryEnvironment queryEnv) {
        this(new EvaluationServices(queryEnv));
    }

    public AstEvaluator(EvaluationServices services) {
        this.services = services;
    }

    protected void pushVariables(Map<String, Object> variables) {
        this.variablesStack.addLast(variables);
    }

    protected Map<String, Object> peekVariables() {
        return this.variablesStack.peekLast();
    }

    protected Map<String, Object> popVariables() {
        return this.variablesStack.removeLast();
    }

    public EvaluationResult eval(Map<String, Object> varDefinitions, Expression ast) {
        IType nullType;
        Object result;
        this.pushVariables(varDefinitions);
        this.diagnostic = new BasicDiagnostic();
        Object value = this.doSwitch(ast);
        if (value != null && value.getClass() == NullValue.class) {
            result = null;
            nullType = ((NullValue)value).getType();
        } else if (value == null) {
            result = value;
            nullType = new ClassType(this.services.getQueryEnvironment(), null);
        } else {
            result = value;
            nullType = null;
        }
        this.popVariables();
        return new EvaluationResult(result, nullType, this.diagnostic);
    }

    @Override
    public Object caseBooleanLiteral(BooleanLiteral object) {
        return object.isValue();
    }

    @Override
    public Object caseIntegerLiteral(IntegerLiteral object) {
        return object.getValue();
    }

    @Override
    public Object caseRealLiteral(RealLiteral object) {
        return object.getValue();
    }

    @Override
    public Object caseStringLiteral(StringLiteral object) {
        return object.getValue();
    }

    @Override
    public Object caseClassTypeLiteral(ClassTypeLiteral object) {
        return object.getValue();
    }

    @Override
    public Object caseEClassifierTypeLiteral(EClassifierTypeLiteral object) {
        Object result;
        EClassifier eClassifier = this.services.getEClassifier(object);
        if (eClassifier != null) {
            result = eClassifier;
        } else {
            Nothing nothing = new Nothing("Invalid classifier.");
            BasicDiagnostic diag = new BasicDiagnostic(4, "org.eclipse.acceleo.query", 0, nothing.getMessage(), new Object[]{object});
            ((BasicDiagnostic)this.diagnostic).add((Diagnostic)diag);
            result = nothing;
        }
        return result;
    }

    @Override
    public Object caseCall(Call object) {
        EList<Expression> exprArgs = object.getArguments();
        int argc = exprArgs.size();
        Object[] args = new Object[argc];
        int i = 0;
        for (Expression arg : exprArgs) {
            args[i++] = this.doSwitch(arg);
        }
        Object result = this.services.call(object, args, this.diagnostic);
        return result;
    }

    @Override
    public Object caseAnd(And object) {
        Object result;
        Object[] args = new Object[2];
        args[0] = this.doSwitch((EObject)object.getArguments().get(0));
        if (args[0] != null && args[0].getClass() == Boolean.class && Boolean.FALSE.equals(args[0])) {
            result = Boolean.FALSE;
        } else {
            args[1] = this.doSwitch((EObject)object.getArguments().get(1));
            result = this.services.call(object, args, this.diagnostic);
        }
        return result;
    }

    @Override
    public Object caseOr(Or object) {
        Object result;
        Object[] args = new Object[2];
        args[0] = this.doSwitch((EObject)object.getArguments().get(0));
        if (args[0] != null && args[0].getClass() == Boolean.class && Boolean.TRUE.equals(args[0])) {
            result = Boolean.TRUE;
        } else {
            args[1] = this.doSwitch((EObject)object.getArguments().get(1));
            result = this.services.call(object, args, this.diagnostic);
        }
        return result;
    }

    @Override
    public Object caseImplies(Implies object) {
        Object result;
        Object[] args = new Object[2];
        args[0] = this.doSwitch((EObject)object.getArguments().get(0));
        if (args[0] != null && args[0].getClass() == Boolean.class && Boolean.FALSE.equals(args[0])) {
            result = Boolean.TRUE;
        } else {
            args[1] = this.doSwitch((EObject)object.getArguments().get(1));
            result = this.services.call(object, args, this.diagnostic);
        }
        return result;
    }

    @Override
    public Object caseVarRef(VarRef object) {
        return this.services.getVariableValue(this.peekVariables(), object.getVariableName(), this.diagnostic);
    }

    @Override
    public Object caseLambda(Lambda object) {
        return new LambdaValue(object, new HashMap<String, Object>(this.peekVariables()), this, this.diagnostic);
    }

    @Override
    public Object caseNullLiteral(NullLiteral object) {
        return null;
    }

    @Override
    public Object caseEnumLiteral(EnumLiteral object) {
        Object result;
        EEnumLiteral literal = this.services.getEEnumLiteral(object);
        if (literal != null) {
            result = literal.getInstance();
        } else {
            Nothing nothing = new Nothing("Invalid enum literal.");
            BasicDiagnostic diag = new BasicDiagnostic(4, "org.eclipse.acceleo.query", 0, nothing.getMessage(), new Object[]{object});
            ((BasicDiagnostic)this.diagnostic).add((Diagnostic)diag);
            result = nothing;
        }
        return result;
    }

    @Override
    public Object caseSetInExtensionLiteral(SetInExtensionLiteral object) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        for (Expression expression : object.getValues()) {
            result.add(this.doSwitch(expression));
        }
        return result;
    }

    @Override
    public Object caseSequenceInExtensionLiteral(SequenceInExtensionLiteral object) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Expression expression : object.getValues()) {
            result.add(this.doSwitch(expression));
        }
        return result;
    }

    @Override
    public Object caseConditional(Conditional object) {
        Object result;
        Object selector = this.doSwitch(object.getPredicate());
        if (selector instanceof Boolean) {
            result = ((Boolean)selector).booleanValue() ? this.doSwitch(object.getTrueBranch()) : this.doSwitch(object.getFalseBranch());
        } else {
            Nothing nothing = new Nothing(String.format(BAD_PREDICATE_TYPE_MSG, selector));
            BasicDiagnostic diag = new BasicDiagnostic(2, "org.eclipse.acceleo.query", 0, nothing.getMessage(), new Object[]{object.getPredicate()});
            ((BasicDiagnostic)this.diagnostic).add((Diagnostic)diag);
            result = nothing;
        }
        return result;
    }

    @Override
    public Object caseLet(Let object) {
        HashMap<String, Object> letEnv = new HashMap<String, Object>(this.peekVariables());
        for (Binding binding : object.getBindings()) {
            letEnv.put(binding.getName(), this.doSwitch(binding.getValue()));
        }
        this.pushVariables(letEnv);
        Object result = this.doSwitch(object.getBody());
        this.popVariables();
        return result;
    }

    @Override
    public Object caseTypeSetLiteral(TypeSetLiteral object) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>(object.getTypes().size());
        for (TypeLiteral type : object.getTypes()) {
            result.add(this.doSwitch(type));
        }
        return result;
    }
}

