/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl.completion;

import org.eclipse.acceleo.query.parser.AstBuilder;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EEnumLiteralCompletionProposal
implements ICompletionProposal {
    private final EEnumLiteral literal;

    public EEnumLiteralCompletionProposal(EEnumLiteral literal) {
        this.literal = literal;
    }

    @Override
    public String getProposal() {
        String packageName = AstBuilder.protectWithUnderscore(this.literal.getEEnum().getEPackage().getName());
        String enumName = AstBuilder.protectWithUnderscore(this.literal.getEEnum().getName());
        String literalName = AstBuilder.protectWithUnderscore(this.literal.getName());
        return packageName + "::" + enumName + "::" + literalName;
    }

    @Override
    public int getCursorOffset() {
        return this.getProposal().length();
    }

    public EEnumLiteral getObject() {
        return this.literal;
    }

    public String toString() {
        return this.getProposal();
    }

    @Override
    public String getDescription() {
        StringBuffer result = new StringBuffer();
        result.append(this.literal.eClass().getName());
        result.append(" named ");
        result.append(this.literal.getName());
        result.append(" in ");
        result.append(this.literal.getEEnum().getName());
        result.append('(');
        result.append(this.literal.getEEnum().getEPackage().getNsURI());
        result.append(')');
        String doc = EcoreUtil.getDocumentation((EModelElement)this.literal);
        if (doc != null) {
            result.append('\n');
            result.append(doc);
        }
        return result.toString();
    }
}

