/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.richtext.painter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.nebula.widgets.richtext.painter.instructions.FontMetricsProvider;
import org.eclipse.nebula.widgets.richtext.painter.instructions.PaintInstruction;
import org.eclipse.nebula.widgets.richtext.painter.instructions.TextPaintInstruction;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class LinePainter {
    private Collection<PaintInstruction> instructions = new ArrayList<PaintInstruction>();
    private FontMetrics biggestMetrics = null;
    private int contentWidth = 0;
    private int trimmedContentWidth = 0;
    private int justifySpace = 0;
    private int roundingPixels = 0;
    private List<String> words = new ArrayList<String>();

    public void paint(GC gc, Rectangle area) {
        Font beforeFont = gc.getFont();
        FontMetrics biggestMetrics = gc.getFontMetrics();
        for (PaintInstruction instruction : this.instructions) {
            FontMetrics metrics;
            if (instruction instanceof FontMetricsProvider && (metrics = ((FontMetricsProvider)((Object)instruction)).getFontMetrics(gc)).getHeight() > biggestMetrics.getHeight()) {
                biggestMetrics = metrics;
            }
            if (!(instruction instanceof TextPaintInstruction)) continue;
            this.words.addAll(((TextPaintInstruction)instruction).getWords());
        }
        int wordCount = this.words.size() > 1 ? this.words.size() - 1 : 1;
        this.justifySpace = (area.width - this.getTrimmedContentWidth()) / wordCount;
        this.roundingPixels = area.width - (this.getTrimmedContentWidth() + this.justifySpace * wordCount);
        gc.setFont(beforeFont);
        this.biggestMetrics = biggestMetrics;
        for (PaintInstruction instruction : this.instructions) {
            instruction.paint(gc, area);
        }
    }

    public void addInstruction(PaintInstruction instruction) {
        this.instructions.add(instruction);
    }

    public FontMetrics getBiggestMetrics() {
        return this.biggestMetrics;
    }

    public int getLineHeight() {
        return this.biggestMetrics.getHeight();
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public void increaseContentWidth(int width) {
        this.contentWidth += width;
    }

    public int getTrimmedContentWidth() {
        return this.trimmedContentWidth;
    }

    public void increaseTrimmedContentWidth(int width) {
        this.trimmedContentWidth += width;
    }

    public int getNextJustifySpace() {
        int result = this.justifySpace;
        if (this.roundingPixels > 0) {
            result += this.roundingPixels--;
        }
        return result;
    }
}

