/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.widget;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.ui.widget.I4diacTableUtil;
import org.eclipse.fordiac.ide.ui.widget.TableCopyAction;
import org.eclipse.fordiac.ide.ui.widget.TableCutAction;
import org.eclipse.fordiac.ide.ui.widget.TablePasteAction;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.TabContents;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public final class TableWidgetFactory {
    private static List<IWorkbenchSite> handledSites = new ArrayList<IWorkbenchSite>();

    public static TableViewer createTableViewer(Composite parent) {
        return TableWidgetFactory.createTableViewer(parent, 0);
    }

    public static TableViewer createTableViewer(Composite parent, int style) {
        GridData gridData = new GridData(4, 4, true, true);
        TableViewer tableViewer = TableWidgetFactory.createGenericTableViewer(gridData, parent, style);
        gridData.heightHint = 150;
        gridData.widthHint = 80;
        return tableViewer;
    }

    public static TableViewer createPropertyTableViewer(Composite parent) {
        return TableWidgetFactory.createPropertyTableViewer(parent, 0);
    }

    public static TableViewer createPropertyTableViewer(Composite parent, int style) {
        GridData gridData = new GridData(4, 4, true, true);
        TableViewer tableViewer = TableWidgetFactory.createGenericTableViewer(gridData, parent, style);
        gridData.minimumHeight = 80;
        gridData.heightHint = 4;
        gridData.widthHint = 400;
        return tableViewer;
    }

    private static TableViewer createGenericTableViewer(GridData gridData, Composite parent, int style) {
        TableViewer tableViewer = new TableViewer(parent, 0x10B02 | style);
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(tableViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)tableViewer, false));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && (event.keyCode == 13 || event.keyCode == 0x100000B) || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)tableViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        tableViewer.getControl().setLayoutData((Object)gridData);
        Table table = tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        return tableViewer;
    }

    private TableWidgetFactory() {
        throw new UnsupportedOperationException("Widget Factory should not be instantiated");
    }

    public static void enableCopyPasteCut(Object part) {
        IWorkbenchSite site = TableWidgetFactory.getSite(part);
        if (site != null) {
            for (IWorkbenchSite s : handledSites) {
                if (s != site) continue;
                return;
            }
            ActionRegistry registry = new ActionRegistry();
            TableWidgetFactory.registerActions(part, registry);
            TableWidgetFactory.setActionHandlers(site, registry);
            handledSites.add(site);
        }
    }

    private static void registerActions(Object part, ActionRegistry registry) {
        Action action = new TableCopyAction(part);
        registry.registerAction((IAction)action);
        action = new TablePasteAction(part);
        registry.registerAction((IAction)action);
        action = new TableCutAction(part);
        registry.registerAction((IAction)action);
    }

    private static void setActionHandlers(IWorkbenchSite site, ActionRegistry registry) {
        IActionBars bars = TableWidgetFactory.getActionBars(site);
        if (bars != null) {
            String id = ActionFactory.COPY.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = ActionFactory.PASTE.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            id = ActionFactory.CUT.getId();
            bars.setGlobalActionHandler(id, registry.getAction((Object)id));
            bars.updateActionBars();
        }
    }

    private static IActionBars getActionBars(IWorkbenchSite site) {
        if (site instanceof IEditorSite) {
            return ((IEditorSite)site).getActionBars();
        }
        if (site instanceof IPageSite) {
            return ((IPageSite)site).getActionBars();
        }
        return null;
    }

    private static IWorkbenchSite getSite(Object part) {
        if (part instanceof IWorkbenchPart) {
            return ((IWorkbenchPart)part).getSite();
        }
        if (part instanceof IPageBookViewPage) {
            return ((TabbedPropertySheetPage)part).getSite();
        }
        return null;
    }

    public static I4diacTableUtil getTableEditor(Object part) {
        if (part instanceof IWorkbenchPart) {
            return TableWidgetFactory.getTableEditorFromWorkbenchPart((IWorkbenchPart)part);
        }
        if (part instanceof IPageBookViewPage) {
            return TableWidgetFactory.getTableEditorFromPropertySheet((TabbedPropertySheetPage)part);
        }
        return null;
    }

    private static I4diacTableUtil getTableEditorFromWorkbenchPart(IWorkbenchPart part) {
        IWorkbenchWindow window = part.getSite().getWorkbenchWindow();
        ISelection sel = window.getSelectionService().getSelection();
        Object editor = sel instanceof StructuredSelection ? ((StructuredSelection)sel).getFirstElement() : null;
        return editor instanceof I4diacTableUtil ? (I4diacTableUtil)editor : null;
    }

    private static I4diacTableUtil getTableEditorFromPropertySheet(TabbedPropertySheetPage part) {
        TabContents content = part.getCurrentTab();
        ISection section = content.getSectionAtIndex(0);
        return section instanceof I4diacTableUtil ? (I4diacTableUtil)section : null;
    }
}

