/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.libraryElement.impl;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.impl.ConnectionAnnotations;
import org.eclipse.fordiac.ide.model.libraryElement.impl.NamedElementAnnotations;
import org.eclipse.fordiac.ide.model.typelibrary.ErrorTypeEntry;

public final class AttributeAnnotations {
    private static final String NAMED_ELEMENTS_KEY = AttributeAnnotations.class.getName() + ".NAMED_ELEMENTS";

    public static String getQualifiedName(Attribute attribute) {
        EObject eObject = attribute.eContainer();
        if (eObject instanceof Connection) {
            Connection connection = (Connection)eObject;
            return ConnectionAnnotations.getConnectionQualifiedName(connection) + "." + attribute.getName();
        }
        return NamedElementAnnotations.getQualifiedName(attribute);
    }

    public static boolean validateAttributeDeclaration(Attribute attribute, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (attribute.getAttributeDeclaration() != null && attribute.getAttributeDeclaration().getTypeEntry() instanceof ErrorTypeEntry) {
            if (diagnostics != null) {
                diagnostics.add(AttributeAnnotations.createAttributeValidationDiagnostic(MessageFormat.format(Messages.AttributeAnnotations_MissingAttributeDeclaration, attribute.getName()), attribute));
            }
            return false;
        }
        return true;
    }

    private static Diagnostic createAttributeValidationDiagnostic(String message, Attribute attribute) {
        return new BasicDiagnostic(4, "org.eclipse.fordiac.ide.model.libraryElement", 2, message, FordiacMarkerHelper.getDiagnosticData((EObject)attribute, (EStructuralFeature)LibraryElementPackage.Literals.ATTRIBUTE__ATTRIBUTE_DECLARATION, attribute.getName()));
    }

    public static boolean validateName(Attribute attribute, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (InternalAttributeDeclarations.isInternalAttribute(attribute.getAttributeDeclaration())) {
            return true;
        }
        return (attribute.getAttributeDeclaration() != null || NamedElementAnnotations.validateName(attribute, diagnostics, context)) && NamedElementAnnotations.validateDuplicateName(attribute, diagnostics, context, NAMED_ELEMENTS_KEY);
    }

    private AttributeAnnotations() {
        throw new UnsupportedOperationException();
    }
}

